/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.antisamy.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;

public class AntiSamySanitizerImpl
implements Sanitizer {
    private static final Log _log = LogFactoryUtil.getLog(AntiSamySanitizerImpl.class);
    private final List<String> _blacklist = new ArrayList<String>();
    private final Map<String, Policy> _policies = new HashMap<String, Policy>();
    private final Policy _policy;
    private final List<String> _whitelist = new ArrayList<String>();

    public AntiSamySanitizerImpl(String[] blacklist, URL url, String[] whitelist) {
        try (InputStream inputstream = url.openStream();){
            this._policy = Policy.getInstance((InputStream)inputstream);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to initialize policy", exception);
        }
        if (blacklist != null) {
            for (String blacklistItem : blacklist) {
                if ((blacklistItem = blacklistItem.trim()).isEmpty()) continue;
                blacklistItem = this.stripTrailingStar(blacklistItem);
                this._blacklist.add(blacklistItem);
            }
        }
        if (whitelist != null) {
            for (String whitelistItem : whitelist) {
                if ((whitelistItem = whitelistItem.trim()).isEmpty()) continue;
                whitelistItem = this.stripTrailingStar(whitelistItem);
                this._whitelist.add(whitelistItem);
            }
        }
    }

    public void addPolicy(String className, URL url) {
        try (InputStream inputstream = url.openStream();){
            Policy policy = Policy.getInstance((InputStream)inputstream);
            this._policies.put(className, policy);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to initialize policy", exception);
        }
    }

    public void removePolicy(String className) {
        this._policies.remove(className);
    }

    public String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, String content, Map<String, Object> options) throws SanitizerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sanitizing ", className, "#", classPK}));
        }
        if (Validator.isNull((String)content)) {
            return content;
        }
        if (Validator.isNull((String)contentType) || !contentType.equals("text/html")) {
            return content;
        }
        if (this.isWhitelisted(className, classPK)) {
            return content;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(AntiSamySanitizerImpl.class.getClassLoader());
        try {
            CleanResults cleanResults = null;
            AntiSamy antiSamy = new AntiSamy();
            if (this.isConfigured(className, classPK)) {
                Policy policy = this._policies.get(className);
                cleanResults = antiSamy.scan(content, policy, 1);
            } else {
                cleanResults = antiSamy.scan(content, this._policy);
            }
            if (_log.isWarnEnabled()) {
                for (String errorMessage : cleanResults.getErrorMessages()) {
                    _log.warn((Object)errorMessage);
                }
            }
            String string = cleanResults.getCleanHTML();
            return string;
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to sanitize input", (Throwable)exception);
            throw new SanitizerException((Throwable)exception);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected boolean isConfigured(String className, long classPK) {
        String classNameAndClassPK = className + "#" + classPK;
        for (String policyClassName : this._policies.keySet()) {
            if (!classNameAndClassPK.startsWith(policyClassName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isWhitelisted(String className, long classPK) {
        String classNameAndClassPK = className + "#" + classPK;
        for (String blacklistItem : this._blacklist) {
            if (!blacklistItem.equals("*") && !classNameAndClassPK.startsWith(blacklistItem)) continue;
            return false;
        }
        for (String whitelistItem : this._whitelist) {
            if (!whitelistItem.equals("*") && !classNameAndClassPK.startsWith(whitelistItem)) continue;
            return true;
        }
        return false;
    }

    protected String stripTrailingStar(String item) {
        if (item.equals("*")) {
            return item;
        }
        char c = item.charAt(item.length() - 1);
        if (c == '*') {
            return item.substring(0, item.length() - 1);
        }
        return item;
    }
}

