/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.beanshell.internal;

import bsh.Interpreter;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.scripting.BaseScriptingExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"scripting.language=beanshell"}, service={ScriptingExecutor.class})
public class BeanShellExecutor
extends BaseScriptingExecutor {
    public static final String LANGUAGE = "beanshell";

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for BeanShell");
        }
        try {
            Interpreter interpreter = new Interpreter();
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                interpreter.set(entry.getKey(), entry.getValue());
            }
            interpreter.setClassLoader(this.getClassLoader());
            interpreter.eval(script);
            if (outputNames == null) {
                return null;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, interpreter.get(outputName));
            }
            return outputObjects;
        }
        catch (Exception e) {
            throw new ScriptingException(e.getMessage(), (Throwable)e);
        }
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    public ScriptingExecutor newInstance(boolean executeInSeparateThread) {
        return new BeanShellExecutor();
    }
}

