/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.multiple.internal;

import com.liferay.portal.kernel.annotation.AnnotationLocator;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutorUtil;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.ClusterableInvokerUtil;
import com.liferay.portal.kernel.cluster.NullClusterable;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClusterableProxyFactory {
    public static <T> T createClusterableProxy(T targetObject) {
        Class<?> targetClass = targetObject.getClass();
        return (T)ProxyUtil.newProxyInstance((ClassLoader)targetClass.getClassLoader(), (Class[])targetClass.getInterfaces(), new ClusterableInvocationHandler(targetObject));
    }

    private static class ClusterableInvocationHandler<T>
    implements InvocationHandler {
        private static final Map<MethodKey, Clusterable> _clusterables = new ConcurrentHashMap<MethodKey, Clusterable>();
        private final T _targetObject;

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            if (!ClusterInvokeThreadLocal.isEnabled()) {
                return method.invoke(this._targetObject, arguments);
            }
            Clusterable clusterable = this._getClusterable(method, this._targetObject.getClass());
            if (clusterable == NullClusterable.NULL_CLUSTERABLE) {
                return method.invoke(this._targetObject, arguments);
            }
            if (clusterable.onMaster()) {
                if (ClusterMasterExecutorUtil.isMaster()) {
                    return method.invoke(this._targetObject, arguments);
                }
                return ClusterableInvokerUtil.invokeOnMaster((Class)clusterable.acceptor(), this._targetObject, (Method)method, (Object[])arguments);
            }
            Object result = method.invoke(this._targetObject, arguments);
            ClusterableInvokerUtil.invokeOnCluster((Class)clusterable.acceptor(), this._targetObject, (Method)method, (Object[])arguments);
            return result;
        }

        private ClusterableInvocationHandler(T targetObject) {
            this._targetObject = targetObject;
        }

        private Clusterable _getClusterable(Method method, Class<?> targetClass) {
            MethodKey methodKey = new MethodKey(targetClass, method.getName(), (Class[])method.getParameterTypes());
            Clusterable clusterable = _clusterables.get(methodKey);
            if (clusterable != null) {
                return clusterable;
            }
            clusterable = (Clusterable)AnnotationLocator.locate((Method)method, this._targetObject.getClass(), Clusterable.class);
            if (clusterable == null) {
                clusterable = NullClusterable.NULL_CLUSTERABLE;
            }
            _clusterables.put(methodKey, clusterable);
            return clusterable;
        }
    }
}

