/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.multiple.internal;

import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactory;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.scheduler.BaseSchedulerEngineConfigurator;
import com.liferay.portal.scheduler.multiple.internal.ClusterSchedulerEngine;
import com.liferay.portal.scheduler.multiple.internal.ClusterableProxyFactory;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ClusterSchedulerEngineConfigurator.class})
public class ClusterSchedulerEngineConfigurator
extends BaseSchedulerEngineConfigurator {
    private ClusterExecutor _clusterExecutor;
    private ClusterLink _clusterLink;
    private ClusterMasterExecutor _clusterMasterExecutor;
    private Props _props;
    private volatile ServiceRegistration<SchedulerEngine> _schedulerEngineServiceRegistration;
    private ServiceRegistration<IdentifiableOSGiService> _serviceRegistration;
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(BundleContext bundleContext) {
        SchedulerEngine schedulerEngine = this.createSchedulerEngineProxy();
        if (this._clusterLink.isEnabled()) {
            ClusterSchedulerEngine clusterSchedulerEngine = new ClusterSchedulerEngine(schedulerEngine, this._triggerFactory);
            clusterSchedulerEngine.setClusterExecutor(this._clusterExecutor);
            clusterSchedulerEngine.setClusterMasterExecutor(this._clusterMasterExecutor);
            clusterSchedulerEngine.setProps(this._props);
            this._serviceRegistration = bundleContext.registerService(IdentifiableOSGiService.class, (Object)clusterSchedulerEngine, (Dictionary)new HashMapDictionary());
            schedulerEngine = ClusterableProxyFactory.createClusterableProxy(clusterSchedulerEngine);
        }
        this._schedulerEngineServiceRegistration = this.registerSchedulerEngine(bundleContext, schedulerEngine);
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
        if (this._schedulerEngineServiceRegistration != null) {
            this._schedulerEngineServiceRegistration.unregister();
        }
    }

    @Reference(unbind="-")
    protected void setClusterExecutor(ClusterExecutor clusterExecutor) {
        this._clusterExecutor = clusterExecutor;
    }

    @Reference(unbind="-")
    protected void setClusterLink(ClusterLink clusterLink) {
        this._clusterLink = clusterLink;
    }

    @Reference(unbind="-")
    protected void setClusterMasterExecutor(ClusterMasterExecutor clusterMasterExecutor) {
        this._clusterMasterExecutor = clusterMasterExecutor;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    @Reference(unbind="-")
    protected void setSingleDestinationMessageSenderFactory(SingleDestinationMessageSenderFactory singleDestinationMessageSenderFactory) {
    }

    @Reference(unbind="-")
    protected void TriggerFactory(TriggerFactory triggerFactory) {
        this._triggerFactory = triggerFactory;
    }
}

