/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.persistence.impl;

import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.reports.engine.console.model.Source;
import com.liferay.portal.reports.engine.console.model.impl.SourceImpl;
import com.liferay.portal.reports.engine.console.service.persistence.SourceFinder;
import com.liferay.portal.reports.engine.console.service.persistence.impl.SourceFinderBaseImpl;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SourceFinder.class})
public class SourceFinderImpl
extends SourceFinderBaseImpl
implements SourceFinder {
    public static final String COUNT_BY_G_N_DU = SourceFinder.class.getName() + ".countByG_N_DU";
    public static final String FIND_BY_G_N_DU = SourceFinder.class.getName() + ".findByG_N_DU";
    @Reference
    private CustomSQL _customSQL;

    public int countByG_N_DU(long groupId, String name, String driverUrl, boolean andOperator) {
        return this.doCountByG_N_DU(groupId, name, driverUrl, andOperator, false);
    }

    public int filterCountByG_N_DU(long groupId, String name, String driverUrl, boolean andOperator) {
        return this.doCountByG_N_DU(groupId, name, driverUrl, andOperator, true);
    }

    public List<Source> filterFindByG_N_DU(long groupId, String name, String driverUrl, boolean andOperator, int start, int end, OrderByComparator<Source> orderByComparator) {
        return this.doFindByG_N_DU(groupId, name, driverUrl, andOperator, start, end, orderByComparator, true);
    }

    public List<Source> findByG_N_DU(long groupId, String name, String driverUrl, boolean andOperator, int start, int end, OrderByComparator<Source> orderByComparator) {
        return this.doFindByG_N_DU(groupId, name, driverUrl, andOperator, start, end, orderByComparator, false);
    }

    protected int doCountByG_N_DU(long groupId, String name, String driverUrl, boolean andOperator, boolean inlineSQLHelper) {
        if (Validator.isNull((String)name) || Validator.isNull((String)driverUrl)) {
            andOperator = true;
        }
        String[] names = this._customSQL.keywords(name);
        String[] driverUrls = this._customSQL.keywords(driverUrl);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_N_DU);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)Source.class.getName(), (String)"Reports_Source.sourceId", (long)groupId);
            }
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(Reports_Source.groupId = ?) AND");
            }
            sql = this._customSQL.replaceKeywords(sql, "LOWER(CAST_TEXT(Reports_Source.name))", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(Reports_Source.driverUrl)", "LIKE", true, driverUrls);
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            queryPos.add(names, 2);
            queryPos.add(driverUrls, 2);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Source> doFindByG_N_DU(long groupId, String name, String driverUrl, boolean andOperator, int start, int end, OrderByComparator<Source> orderByComparator, boolean inlineSQLHelper) {
        if (Validator.isNull((String)name) || Validator.isNull((String)driverUrl)) {
            andOperator = true;
        }
        String[] names = this._customSQL.keywords(name);
        String[] driverUrls = this._customSQL.keywords(driverUrl);
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_N_DU);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)Source.class.getName(), (String)"Reports_Source.sourceId", (long)groupId);
            }
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(Reports_Source.groupId = ?) AND");
            }
            sql = this._customSQL.replaceKeywords(sql, "LOWER(CAST_TEXT(Reports_Source.name))", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(Reports_Source.driverUrl)", "LIKE", true, driverUrls);
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            if (orderByComparator != null) {
                sql = this._customSQL.replaceOrderBy(sql, orderByComparator);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Reports_Source", SourceImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            queryPos.add(names, 2);
            queryPos.add(driverUrls, 2);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

