/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.reports.engine.console.exception.NoSuchEntryException;
import com.liferay.portal.reports.engine.console.model.Entry;
import com.liferay.portal.reports.engine.console.model.EntryTable;
import com.liferay.portal.reports.engine.console.model.impl.EntryImpl;
import com.liferay.portal.reports.engine.console.model.impl.EntryModelImpl;
import com.liferay.portal.reports.engine.console.service.persistence.EntryPersistence;
import com.liferay.portal.reports.engine.console.service.persistence.EntryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={EntryPersistence.class})
public class EntryPersistenceImpl
extends BasePersistenceImpl<Entry>
implements EntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = EntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ENTRY = "SELECT entry FROM Entry entry";
    private static final String _SQL_COUNT_ENTRY = "SELECT COUNT(entry) FROM Entry entry";
    private static final String _ORDER_BY_ENTITY_ALIAS = "entry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Entry exists with the primary key ";
    private static final Log _log = LogFactoryUtil.getLog(EntryPersistenceImpl.class);

    public EntryPersistenceImpl() {
        this.setModelClass(Entry.class);
        this.setModelImplClass(EntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)EntryTable.INSTANCE);
    }

    public void cacheResult(Entry entry) {
        this.entityCache.putResult(EntryImpl.class, (Serializable)Long.valueOf(entry.getPrimaryKey()), (Serializable)entry);
    }

    public void cacheResult(List<Entry> entries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && entries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Entry entry : entries) {
            if (this.entityCache.getResult(EntryImpl.class, (Serializable)Long.valueOf(entry.getPrimaryKey())) != null) continue;
            this.cacheResult(entry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(EntryImpl.class);
        this.finderCache.clearCache(EntryImpl.class);
    }

    public void clearCache(Entry entry) {
        this.entityCache.removeResult(EntryImpl.class, (BaseModel)entry);
    }

    public void clearCache(List<Entry> entries) {
        for (Entry entry : entries) {
            this.entityCache.removeResult(EntryImpl.class, (BaseModel)entry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(EntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(EntryImpl.class, primaryKey);
        }
    }

    public Entry create(long entryId) {
        EntryImpl entry = new EntryImpl();
        entry.setNew(true);
        entry.setPrimaryKey(entryId);
        entry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return entry;
    }

    public Entry remove(long entryId) throws NoSuchEntryException {
        return this.remove(Long.valueOf(entryId));
    }

    public Entry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            Entry entry = (Entry)session.get(EntryImpl.class, primaryKey);
            if (entry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            Entry entry2 = (Entry)this.remove((BaseModel)entry);
            return entry2;
        }
        catch (NoSuchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Entry removeImpl(Entry entry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)entry)) {
                entry = (Entry)session.get(EntryImpl.class, entry.getPrimaryKeyObj());
            }
            if (entry != null) {
                session.delete((Object)entry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (entry != null) {
            this.clearCache(entry);
        }
        return entry;
    }

    public Entry updateImpl(Entry entry) {
        boolean isNew = entry.isNew();
        if (!(entry instanceof EntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)entry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)entry);
                throw new IllegalArgumentException("Implement ModelWrapper in entry proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Entry implementation " + String.valueOf(entry.getClass()));
        }
        EntryModelImpl entryModelImpl = (EntryModelImpl)entry;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && entry.getCreateDate() == null) {
            if (serviceContext == null) {
                entry.setCreateDate(date);
            } else {
                entry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!entryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                entry.setModifiedDate(date);
            } else {
                entry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)entry);
            } else {
                entry = (Entry)session.merge((Object)entry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(EntryImpl.class, (BaseModel)entry, false, true);
        if (isNew) {
            entry.setNew(false);
        }
        entry.resetOriginalValues();
        return entry;
    }

    public Entry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        Entry entry = (Entry)this.fetchByPrimaryKey(primaryKey);
        if (entry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return entry;
    }

    public Entry findByPrimaryKey(long entryId) throws NoSuchEntryException {
        return this.findByPrimaryKey(Long.valueOf(entryId));
    }

    public Entry fetchByPrimaryKey(long entryId) {
        return (Entry)this.fetchByPrimaryKey(Long.valueOf(entryId));
    }

    public List<Entry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Entry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Entry> findAll(int start, int end, OrderByComparator<Entry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Entry> findAll(int start, int end, OrderByComparator<Entry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ENTRY;
                sql = sql.concat(" ORDER BY entry.modifiedDate ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Entry entry : this.findAll()) {
            this.remove((BaseModel)entry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "entryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return EntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        EntryUtil.setPersistence((EntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        EntryUtil.setPersistence(null);
        this.entityCache.removeCache(EntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.portal.reports.engine.console.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.reports.engine.console.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.portal.reports.engine.console.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

