/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.persistence.impl;

import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.reports.engine.console.model.Definition;
import com.liferay.portal.reports.engine.console.model.impl.DefinitionImpl;
import com.liferay.portal.reports.engine.console.service.persistence.DefinitionFinder;
import com.liferay.portal.reports.engine.console.service.persistence.impl.DefinitionFinderBaseImpl;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DefinitionFinder.class})
public class DefinitionFinderImpl
extends DefinitionFinderBaseImpl
implements DefinitionFinder {
    public static final String COUNT_BY_G_S_N_D_RN = DefinitionFinder.class.getName() + ".countByG_S_N_D_RN";
    public static final String FIND_BY_G_S_N_D_RN = DefinitionFinder.class.getName() + ".findByG_S_N_D_RN";
    @Reference
    private CustomSQL _customSQL;

    public int countByG_S_N_D_RN(long groupId, String name, String description, long sourceId, String reportName, boolean andOperator) {
        return this.doCountByG_S_N_D_RN(groupId, name, description, sourceId, reportName, andOperator, false);
    }

    public int filterCountByG_S_N_D_RN(long groupId, String name, String description, long sourceId, String reportName, boolean andOperator) {
        return this.doCountByG_S_N_D_RN(groupId, name, description, sourceId, reportName, andOperator, true);
    }

    public List<Definition> filterFindByG_S_N_D_RN(long groupId, String name, String description, long sourceId, String reportName, boolean andOperator, int start, int end, OrderByComparator<Definition> orderByComparator) {
        return this.doFindByG_S_N_D_RN(groupId, name, description, sourceId, reportName, andOperator, start, end, orderByComparator, true);
    }

    public List<Definition> findByG_S_N_D_RN(long groupId, String name, String description, long sourceId, String reportName, boolean andOperator, int start, int end, OrderByComparator<Definition> orderByComparator) {
        return this.doFindByG_S_N_D_RN(groupId, name, description, sourceId, reportName, andOperator, start, end, orderByComparator, false);
    }

    protected int doCountByG_S_N_D_RN(long groupId, String name, String description, long sourceId, String reportName, boolean andOperator, boolean inlineSQLHelper) {
        if (Validator.isNull((String)name) || Validator.isNull((String)description) || Validator.isNull((String)reportName)) {
            andOperator = true;
        }
        String[] names = this._customSQL.keywords(name);
        String[] descriptions = this._customSQL.keywords(description);
        String[] reportNames = this._customSQL.keywords(reportName);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_S_N_D_RN);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)Definition.class.getName(), (String)"Reports_Definition.definitionId", (long)groupId);
            }
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(Reports_Definition.groupId = ?) AND");
            }
            if (sourceId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(Reports_Definition.sourceId = ?) [$AND_OR_CONNECTOR$]");
            }
            sql = this._customSQL.replaceKeywords(sql, "LOWER(CAST_TEXT(Reports_Definition.name))", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(CAST_TEXT(Reports_Definition.description))", "LIKE", false, descriptions);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(Reports_Definition.reportName)", "LIKE", true, reportNames);
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            if (sourceId > 0L) {
                queryPos.add(sourceId);
            }
            queryPos.add(names, 2);
            queryPos.add(descriptions, 2);
            queryPos.add(reportNames, 2);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Definition> doFindByG_S_N_D_RN(long groupId, String name, String description, long sourceId, String reportName, boolean andOperator, int start, int end, OrderByComparator<Definition> orderByComparator, boolean inlineSQLHelper) {
        if (Validator.isNull((String)name) || Validator.isNull((String)description) || Validator.isNull((String)reportName)) {
            andOperator = true;
        }
        String[] names = this._customSQL.keywords(name);
        String[] descriptions = this._customSQL.keywords(description);
        String[] reportNames = this._customSQL.keywords(reportName);
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_S_N_D_RN);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)Definition.class.getName(), (String)"Reports_Definition.definitionId", (long)groupId);
            }
            if (groupId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(Reports_Definition.groupId = ?) AND");
            }
            if (sourceId <= 0L) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(Reports_Definition.sourceId = ?) [$AND_OR_CONNECTOR$]");
            }
            sql = this._customSQL.replaceKeywords(sql, "LOWER(CAST_TEXT(Reports_Definition.name))", "LIKE", false, names);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(CAST_TEXT(Reports_Definition.description))", "LIKE", false, descriptions);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(Reports_Definition.reportName)", "LIKE", true, reportNames);
            sql = this._customSQL.replaceAndOperator(sql, andOperator);
            if (orderByComparator != null) {
                sql = this._customSQL.replaceOrderBy(sql, orderByComparator);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Reports_Definition", DefinitionImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (groupId > 0L) {
                queryPos.add(groupId);
            }
            if (sourceId > 0L) {
                queryPos.add(sourceId);
            }
            queryPos.add(names, 2);
            queryPos.add(descriptions, 2);
            queryPos.add(reportNames, 2);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

