/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.reports.engine.console.model.Source;
import com.liferay.portal.reports.engine.console.service.base.SourceServiceBaseImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=reports", "json.web.service.context.path=Source"}, service={AopService.class})
public class SourceServiceImpl
extends SourceServiceBaseImpl {
    @Reference(target="(resource.name=com.liferay.portal.reports.engine.console.admin)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference(target="(model.class.name=com.liferay.portal.reports.engine.console.model.Source)")
    private ModelResourcePermission<Source> _sourceModelResourcePermission;

    public Source addSource(long groupId, Map<Locale, String> nameMap, String driverClassName, String driverUrl, String driverUserName, String driverPassword, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_SOURCE");
        return this.sourceLocalService.addSource(this.getUserId(), groupId, nameMap, driverClassName, driverUrl, driverUserName, driverPassword, serviceContext);
    }

    public Source deleteSource(long sourceId) throws PortalException {
        this._sourceModelResourcePermission.check(this.getPermissionChecker(), sourceId, "DELETE");
        return this.sourceLocalService.deleteSource(sourceId);
    }

    public Source getSource(long sourceId) throws PortalException {
        this._sourceModelResourcePermission.check(this.getPermissionChecker(), sourceId, "VIEW");
        return this.sourceLocalService.getSource(sourceId);
    }

    public List<Source> getSources(long groupId, String name, String driverUrl, boolean andSearch, int start, int end, OrderByComparator<Source> orderByComparator) throws PortalException {
        return this.sourceFinder.filterFindByG_N_DU(groupId, name, driverUrl, andSearch, start, end, orderByComparator);
    }

    public int getSourcesCount(long groupId, String name, String driverUrl, boolean andSearch) {
        return this.sourceFinder.filterCountByG_N_DU(groupId, name, driverUrl, andSearch);
    }

    public Source updateSource(long sourceId, Map<Locale, String> nameMap, String driverClassName, String driverUrl, String driverUserName, String driverPassword, ServiceContext serviceContext) throws PortalException {
        this._sourceModelResourcePermission.check(this.getPermissionChecker(), sourceId, "UPDATE");
        return this.sourceLocalService.updateSource(sourceId, nameMap, driverClassName, driverUrl, driverUserName, driverPassword, serviceContext);
    }
}

