/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.impl;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.reports.engine.console.exception.SourceDriverClassNameException;
import com.liferay.portal.reports.engine.console.model.Source;
import com.liferay.portal.reports.engine.console.service.base.SourceLocalServiceBaseImpl;
import com.liferay.portal.reports.engine.console.util.ReportsEngineConsoleUtil;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.reports.engine.console.model.Source"}, service={AopService.class})
public class SourceLocalServiceImpl
extends SourceLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference(target="(default=true)")
    private Store _store;
    @Reference
    private UserLocalService _userLocalService;

    public Source addSource(long userId, long groupId, Map<Locale, String> nameMap, String driverClassName, String driverUrl, String driverUserName, String driverPassword, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        this._validate(driverClassName, driverUrl, driverUserName, driverPassword);
        long sourceId = this.counterLocalService.increment();
        Source source = this.sourceLocalService.createSource(sourceId);
        source.setUuid(serviceContext.getUuid());
        source.setGroupId(groupId);
        source.setCompanyId(user.getCompanyId());
        source.setUserId(user.getUserId());
        source.setUserName(user.getFullName());
        source.setCreateDate(serviceContext.getCreateDate(date));
        source.setModifiedDate(serviceContext.getModifiedDate(date));
        source.setNameMap(nameMap);
        source.setDriverClassName(driverClassName);
        source.setDriverUrl(driverUrl);
        source.setDriverUserName(driverUserName);
        source.setDriverPassword(driverPassword);
        source = (Source)this.sourcePersistence.update((BaseModel)source);
        this._resourceLocalService.addModelResources((AuditedModel)source, serviceContext);
        return source;
    }

    @Override
    public Source deleteSource(long sourceId) throws PortalException {
        Source source = this.sourcePersistence.findByPrimaryKey(sourceId);
        return this.sourceLocalService.deleteSource(source);
    }

    @Override
    @SystemEvent(type=1)
    public Source deleteSource(Source source) throws PortalException {
        this.sourcePersistence.remove((BaseModel)source);
        this._resourceLocalService.deleteResource(source.getCompanyId(), Source.class.getName(), 4, source.getSourceId());
        return source;
    }

    public void deleteSources(long groupId) throws PortalException {
        List sources = this.sourcePersistence.findByGroupId(groupId);
        for (Source source : sources) {
            this.sourceLocalService.deleteSource(source);
        }
    }

    public String[] getAttachmentsFileNames(Source source) {
        return this._store.getFileNames(source.getCompanyId(), 0L, source.getAttachmentsDir());
    }

    @Override
    public Source getSource(long sourceId) throws PortalException {
        return this.sourcePersistence.findByPrimaryKey(sourceId);
    }

    public List<Source> getSources(long groupId, String name, String driverUrl, boolean andSearch, int start, int end, OrderByComparator<Source> orderByComparator) {
        return this.sourceFinder.findByG_N_DU(groupId, name, driverUrl, andSearch, start, end, orderByComparator);
    }

    public int getSourcesCount(long groupId, String name, String driverUrl, boolean andSearch) {
        return this.sourceFinder.countByG_N_DU(groupId, name, driverUrl, andSearch);
    }

    public Source updateSource(long sourceId, Map<Locale, String> nameMap, String driverClassName, String driverUrl, String driverUserName, String driverPassword, ServiceContext serviceContext) throws PortalException {
        Source source = this.sourcePersistence.findByPrimaryKey(sourceId);
        if (Validator.isNull((String)driverPassword)) {
            driverPassword = source.getDriverPassword();
        }
        this._validate(driverClassName, driverUrl, driverUserName, driverPassword);
        source.setModifiedDate(serviceContext.getModifiedDate(null));
        source.setNameMap(nameMap);
        source.setDriverClassName(driverClassName);
        source.setDriverUrl(driverUrl);
        source.setDriverUserName(driverUserName);
        source.setDriverPassword(driverPassword);
        return (Source)this.sourcePersistence.update((BaseModel)source);
    }

    private void _validate(String driverClassName, String driverUrl, String driverUserName, String driverPassword) throws PortalException {
        ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
        try {
            Class.forName(driverClassName, true, portalClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SourceDriverClassNameException((Throwable)classNotFoundException);
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)portalClassLoader);){
            ReportsEngineConsoleUtil.validateJDBCConnection((String)driverClassName, (String)driverUrl, (String)driverUserName, (String)driverPassword);
        }
    }
}

