/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.reports.engine.console.model.Definition;
import com.liferay.portal.reports.engine.console.model.Entry;
import com.liferay.portal.reports.engine.console.service.base.EntryServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=reports", "json.web.service.context.path=Entry"}, service={AopService.class})
public class EntryServiceImpl
extends EntryServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.portal.reports.engine.console.model.Definition)")
    private ModelResourcePermission<Definition> _definitionModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.portal.reports.engine.console.model.Entry)")
    private ModelResourcePermission<Entry> _entryModelResourcePermission;

    public Entry addEntry(long groupId, long definitionId, String format, boolean schedulerRequest, Date startDate, Date endDate, boolean repeating, String recurrence, String emailNotifications, String emailDelivery, String portletId, String pageURL, String reportName, String reportParameters, ServiceContext serviceContext) throws PortalException {
        this._definitionModelResourcePermission.check(this.getPermissionChecker(), definitionId, "ADD_REPORT");
        return this.entryLocalService.addEntry(this.getUserId(), groupId, definitionId, format, schedulerRequest, startDate, endDate, repeating, recurrence, emailNotifications, emailDelivery, portletId, pageURL, reportName, reportParameters, serviceContext);
    }

    public void deleteAttachment(long companyId, long entryId, String fileName) throws PortalException {
        this._entryModelResourcePermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.entryLocalService.deleteAttachment(companyId, fileName);
    }

    public Entry deleteEntry(long entryId) throws PortalException {
        this._entryModelResourcePermission.check(this.getPermissionChecker(), entryId, "DELETE");
        return this.entryLocalService.deleteEntry(entryId);
    }

    public List<Entry> getEntries(long groupId, String definitionName, String userName, Date createDateGT, Date createDateLT, boolean andSearch, int start, int end, OrderByComparator<Entry> orderByComparator) throws PortalException {
        return this.entryFinder.filterFindByG_CD_N_SN(groupId, definitionName, userName, createDateGT, createDateLT, andSearch, start, end, orderByComparator);
    }

    public int getEntriesCount(long groupId, String definitionName, String userName, Date createDateGT, Date createDateLT, boolean andSearch) throws PortalException {
        return this.entryFinder.filterCountByG_CD_N_SN(groupId, definitionName, userName, createDateGT, createDateLT, andSearch);
    }

    public void sendEmails(long entryId, String fileName, String[] emailAddresses, boolean notification) throws PortalException {
        this._entryModelResourcePermission.check(this.getPermissionChecker(), entryId, "VIEW");
        this.entryLocalService.sendEmails(entryId, fileName, emailAddresses, notification);
    }

    public void unscheduleEntry(long entryId) throws PortalException {
        this._entryModelResourcePermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.entryLocalService.unscheduleEntry(entryId);
    }
}

