/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.impl;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.reports.engine.MemoryReportDesignRetriever;
import com.liferay.portal.reports.engine.ReportDataSourceType;
import com.liferay.portal.reports.engine.ReportDesignRetriever;
import com.liferay.portal.reports.engine.ReportRequest;
import com.liferay.portal.reports.engine.ReportRequestContext;
import com.liferay.portal.reports.engine.console.configuration.ReportsGroupServiceEmailConfiguration;
import com.liferay.portal.reports.engine.console.exception.DefinitionNameException;
import com.liferay.portal.reports.engine.console.exception.EntryEmailDeliveryException;
import com.liferay.portal.reports.engine.console.exception.EntryEmailNotificationsException;
import com.liferay.portal.reports.engine.console.internal.util.ReportsEngineConsoleSubscriptionSender;
import com.liferay.portal.reports.engine.console.model.Definition;
import com.liferay.portal.reports.engine.console.model.Entry;
import com.liferay.portal.reports.engine.console.model.Source;
import com.liferay.portal.reports.engine.console.service.base.EntryLocalServiceBaseImpl;
import com.liferay.portal.reports.engine.console.service.persistence.DefinitionPersistence;
import com.liferay.portal.reports.engine.console.service.persistence.SourcePersistence;
import com.liferay.portal.reports.engine.console.status.ReportStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.reports.engine.console.model.Entry"}, service={AopService.class})
public class EntryLocalServiceImpl
extends EntryLocalServiceBaseImpl {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DefinitionPersistence _definitionPersistence;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Localization _localization;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private SourcePersistence _sourcePersistence;
    @Reference(target="(default=true)")
    private Store _store;
    @Reference
    private TriggerFactory _triggerFactory;
    @Reference
    private UserLocalService _userLocalService;

    public Entry addEntry(long userId, long groupId, long definitionId, String format, boolean schedulerRequest, Date startDate, Date endDate, boolean repeating, String recurrence, String emailNotifications, String emailDelivery, String portletId, String pageURL, String reportName, String reportParameters, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        this._validate(emailNotifications, emailDelivery, reportName);
        long entryId = this.counterLocalService.increment();
        Entry entry = this.entryPersistence.create(entryId);
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(serviceContext.getCreateDate(date));
        entry.setModifiedDate(serviceContext.getModifiedDate(date));
        entry.setDefinitionId(definitionId);
        entry.setFormat(format);
        entry.setScheduleRequest(schedulerRequest);
        entry.setStartDate(startDate);
        entry.setEndDate(endDate);
        entry.setRepeating(repeating);
        entry.setRecurrence(recurrence);
        entry.setEmailNotifications(emailNotifications);
        entry.setEmailDelivery(emailDelivery);
        entry.setPortletId(portletId);
        entry.setReportParameters(reportParameters);
        entry.setPageURL(StringBundler.concat((Object[])new Object[]{pageURL, "&", this._portal.getPortletNamespace(portletId), "entryId=", entryId}));
        entry.setStatus(ReportStatus.PENDING.getValue());
        entry = (Entry)this.entryPersistence.update((BaseModel)entry);
        this._resourceLocalService.addModelResources((AuditedModel)entry, serviceContext);
        if (schedulerRequest) {
            this._scheduleEntry(entry, reportName);
        }
        if (!schedulerRequest) {
            this.generateReport(entryId, reportName);
        }
        return entry;
    }

    public void addEntryResources(Entry entry, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), Entry.class.getName(), entry.getEntryId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addEntryResources(Entry entry, String[] communityPermissions, String[] guestPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(entry.getCompanyId(), entry.getGroupId(), entry.getUserId(), Entry.class.getName(), entry.getEntryId(), communityPermissions, guestPermissions);
    }

    public void deleteAttachment(long companyId, String fileName) throws PortalException {
        this._store.deleteDirectory(companyId, 0L, fileName);
    }

    @Override
    @SystemEvent(type=1)
    public Entry deleteEntry(Entry entry) throws PortalException {
        this.entryPersistence.remove((BaseModel)entry);
        this._resourceLocalService.deleteResource(entry.getCompanyId(), Entry.class.getName(), 4, entry.getEntryId());
        if (entry.isRepeating()) {
            this._schedulerEngineHelper.delete(this._getSchedulerJobName(entry), entry.getSchedulerRequestName(), StorageType.PERSISTED);
        }
        this._store.deleteDirectory(entry.getCompanyId(), 0L, entry.getAttachmentsDir());
        return entry;
    }

    @Override
    public Entry deleteEntry(long entryId) throws PortalException {
        Entry entry = this.entryPersistence.findByPrimaryKey(entryId);
        return this.deleteEntry(entry);
    }

    public void generateReport(long entryId) throws PortalException {
        Entry entry = this.entryPersistence.findByPrimaryKey(entryId);
        Definition definition = this._definitionPersistence.findByPrimaryKey(entry.getDefinitionId());
        this.generateReport(entryId, definition.getReportName());
    }

    public void generateReport(long entryId, String reportName) throws PortalException {
        Entry entry = this.entryPersistence.findByPrimaryKey(entryId);
        Definition definition = this._definitionPersistence.findByPrimaryKey(entry.getDefinitionId());
        String[] existingFiles = definition.getAttachmentsFileNames();
        MemoryReportDesignRetriever retriever = new MemoryReportDesignRetriever(reportName + "." + entry.getFormat(), definition.getModifiedDate(), this._getTemplateFileBytes(definition, existingFiles));
        long sourceId = definition.getSourceId();
        HashMap<String, String> reportParameters = new HashMap<String, String>();
        JSONArray reportParametersJSONArray = this._jsonFactory.createJSONArray(entry.getReportParameters());
        for (int i = 0; i < reportParametersJSONArray.length(); ++i) {
            JSONObject reportParameterJSONObject = reportParametersJSONArray.getJSONObject(i);
            reportParameters.put(reportParameterJSONObject.getString("key"), reportParameterJSONObject.getString("value"));
        }
        ReportRequestContext reportRequestContext = null;
        if (sourceId == 0L) {
            reportRequestContext = new ReportRequestContext(ReportDataSourceType.PORTAL);
        } else {
            Source source = this._sourcePersistence.findByPrimaryKey(sourceId);
            reportRequestContext = new ReportRequestContext(ReportDataSourceType.JDBC);
            reportRequestContext.setAttribute("jdbc.driverClassName", (Serializable)((Object)source.getDriverClassName()));
            reportRequestContext.setAttribute("jdbc.password", (Serializable)((Object)source.getDriverPassword()));
            reportRequestContext.setAttribute("jdbc.url", (Serializable)((Object)source.getDriverUrl()));
            reportRequestContext.setAttribute("jdbc.userName", (Serializable)((Object)source.getDriverUserName()));
        }
        ReportRequest reportRequest = new ReportRequest(reportRequestContext, (ReportDesignRetriever)retriever, reportParameters, entry.getFormat());
        Message message = new Message();
        message.setPayload((Object)reportRequest);
        message.setResponseId(String.valueOf(entry.getEntryId()));
        this._messageBus.sendMessage("liferay/report_request", message);
    }

    public String[] getAttachmentsFileNames(Entry entry) {
        return this._store.getFileNames(entry.getCompanyId(), 0L, entry.getAttachmentsDir());
    }

    public List<Entry> getEntries(long groupId, String definitionName, String userName, Date createDateGT, Date createDateLT, boolean andSearch, int start, int end, OrderByComparator<Entry> orderByComparator) {
        return this.entryFinder.findByG_CD_N_SN(groupId, definitionName, userName, createDateGT, createDateLT, andSearch, start, end, orderByComparator);
    }

    public int getEntriesCount(long groupId, String definitionName, String userName, Date createDateGT, Date createDateLT, boolean andSearch) {
        return this.entryFinder.countByG_CD_N_SN(groupId, definitionName, userName, createDateGT, createDateLT, andSearch);
    }

    public void sendEmails(long entryId, String fileName, String[] emailAddresses, boolean notification) throws PortalException {
        Entry entry = this.entryLocalService.getEntry(entryId);
        try {
            this._notifySubscribers(entry, emailAddresses, fileName, notification);
        }
        catch (IOException ioException) {
            throw new PortalException(ioException.getMessage());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public void unscheduleEntry(long entryId) throws PortalException {
        Entry entry = this.entryPersistence.findByPrimaryKey(entryId);
        entry.setScheduleRequest(false);
        entry.setRepeating(false);
        entry = (Entry)this.entryPersistence.update((BaseModel)entry);
        this._schedulerEngineHelper.delete(this._getSchedulerJobName(entry), entry.getSchedulerRequestName(), StorageType.PERSISTED);
    }

    public void updateEntry(long entryId, String reportName, byte[] reportResults) throws PortalException {
        Entry entry = this.entryPersistence.findByPrimaryKey(entryId);
        Date date = new Date();
        if (entry.isScheduleRequest()) {
            StringBundler sb = new StringBundler(4);
            sb.append(StringUtil.extractFirst((String)reportName, (String)"."));
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"MM_dd_yyyy_HH_mm");
            sb.append(dateFormat.format(date));
            sb.append(".");
            sb.append(StringUtil.extractLast((String)reportName, (String)"."));
            reportName = sb.toString();
        }
        String fileName = entry.getAttachmentsDir() + "/" + reportName;
        try (UnsyncByteArrayInputStream inputStream = new UnsyncByteArrayInputStream(reportResults);){
            this._store.addFile(entry.getCompanyId(), 0L, fileName, "1.0", (InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
        String[] emailAddresses = StringUtil.split((String)entry.getEmailDelivery());
        this.sendEmails(entryId, fileName, emailAddresses, false);
        emailAddresses = StringUtil.split((String)entry.getEmailNotifications());
        this.sendEmails(entryId, fileName, emailAddresses, true);
        entry.setModifiedDate(date);
        entry.setStatus(ReportStatus.COMPLETE.getValue());
        this.entryPersistence.update((BaseModel)entry);
    }

    public void updateEntryStatus(long entryId, ReportStatus status, String errorMessage) throws PortalException {
        Entry entry = this.entryLocalService.getEntry(entryId);
        entry.setErrorMessage(errorMessage);
        entry.setStatus(status.getValue());
        this.entryPersistence.update((BaseModel)entry);
    }

    private InputStream _getReportFileInputStream(Entry entry, String fileName, boolean notification) throws Exception {
        if (notification) {
            return null;
        }
        InputStream inputStream = this._store.getFileAsStream(entry.getCompanyId(), 0L, fileName, "");
        if (inputStream == null) {
            throw new IOException("Unable to open file " + fileName);
        }
        return inputStream;
    }

    private ReportsGroupServiceEmailConfiguration _getReportsGroupServiceEmailConfiguration(long groupId) throws Exception {
        return (ReportsGroupServiceEmailConfiguration)this._configurationProvider.getConfiguration(ReportsGroupServiceEmailConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.portal.reports"));
    }

    private String _getSchedulerJobName(Entry entry) {
        return StringBundler.concat((Object[])new Object[]{entry.getJobName(), "@", entry.getCompanyId()});
    }

    private byte[] _getTemplateFileBytes(Definition definition, String[] existingFiles) throws PortalException {
        try {
            return StreamUtil.toByteArray((InputStream)this._store.getFileAsStream(definition.getCompanyId(), 0L, existingFiles[0], ""));
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    private void _notifySubscribers(Entry entry, String[] emailAddresses, String fileName, boolean notification) throws Exception {
        if (emailAddresses.length == 0) {
            return;
        }
        String portletId = entry.getPortletId();
        ReportsGroupServiceEmailConfiguration reportsGroupServiceEmailConfiguration = this._getReportsGroupServiceEmailConfiguration(entry.getGroupId());
        String fromName = reportsGroupServiceEmailConfiguration.emailFromName();
        String fromAddress = reportsGroupServiceEmailConfiguration.emailFromAddress();
        Map localizedSubjectMap = null;
        Map localizedBodyMap = null;
        if (notification) {
            localizedBodyMap = this._localization.getMap(reportsGroupServiceEmailConfiguration.emailNotificationsBody());
            localizedSubjectMap = this._localization.getMap(reportsGroupServiceEmailConfiguration.emailNotificationsSubject());
        } else {
            localizedBodyMap = this._localization.getMap(reportsGroupServiceEmailConfiguration.emailDeliveryBody());
            localizedSubjectMap = this._localization.getMap(reportsGroupServiceEmailConfiguration.emailDeliverySubject());
        }
        ReportsEngineConsoleSubscriptionSender subscriptionSender = new ReportsEngineConsoleSubscriptionSender();
        String reportName = StringUtil.extractLast((String)fileName, (String)"/");
        if (!notification) {
            subscriptionSender.addFileAttachment(reportName, this._getReportFileInputStream(entry, fileName, notification));
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$FROM_ADDRESS$]", fromAddress, "[$FROM_NAME$]", fromName, "[$PAGE_URL$]", entry.getPageURL(), "[$REPORT_NAME$]", reportName});
        subscriptionSender.setCurrentUserId(entry.getUserId());
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setGroupId(entry.getGroupId());
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("reports_entry", new Object[]{entry.getEntryId()});
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setScopeGroupId(entry.getGroupId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(entry.getCompanyId());
        serviceContext.setScopeGroupId(entry.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        for (String emailAddress : emailAddresses) {
            subscriptionSender.addRuntimeSubscribers(emailAddress, emailAddress);
        }
        subscriptionSender.flushNotificationsAsync();
    }

    private void _scheduleEntry(Entry entry, String reportName) throws PortalException {
        Trigger trigger = this._triggerFactory.createTrigger(this._getSchedulerJobName(entry), entry.getSchedulerRequestName(), entry.getStartDate(), entry.getEndDate(), entry.getRecurrence());
        Message message = new Message();
        message.put("companyId", (Object)entry.getCompanyId());
        message.put("entryId", (Object)entry.getEntryId());
        message.put("reportName", (Object)reportName);
        this._schedulerEngineHelper.schedule(trigger, StorageType.PERSISTED, null, "liferay/reports_scheduler_event", message);
    }

    private void _validate(String emailNotifications, String emailDelivery, String reportName) throws PortalException {
        for (String emailAddress : StringUtil.split((String)emailNotifications)) {
            if (Validator.isEmailAddress((String)emailAddress)) continue;
            throw new EntryEmailNotificationsException();
        }
        for (String emailAddress : StringUtil.split((String)emailDelivery)) {
            if (Validator.isEmailAddress((String)emailAddress)) continue;
            throw new EntryEmailDeliveryException();
        }
        if (Validator.isNull((String)reportName)) {
            throw new DefinitionNameException();
        }
    }
}

