/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.reports.engine.console.model.Definition;
import com.liferay.portal.reports.engine.console.service.base.DefinitionServiceBaseImpl;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=reports", "json.web.service.context.path=Definition"}, service={AopService.class})
public class DefinitionServiceImpl
extends DefinitionServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.portal.reports.engine.console.model.Definition)")
    private ModelResourcePermission<Definition> _definitionModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.portal.reports.engine.console.admin)")
    private PortletResourcePermission _portletResourcePermission;

    public Definition addDefinition(long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long sourceId, String reportParameters, String fileName, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_DEFINITION");
        return this.definitionLocalService.addDefinition(this.getUserId(), groupId, nameMap, descriptionMap, sourceId, reportParameters, fileName, inputStream, serviceContext);
    }

    public Definition deleteDefinition(long definitionId) throws PortalException {
        this._definitionModelResourcePermission.check(this.getPermissionChecker(), definitionId, "DELETE");
        return this.definitionLocalService.deleteDefinition(definitionId);
    }

    public Definition getDefinition(long definitionId) throws PortalException {
        this._definitionModelResourcePermission.check(this.getPermissionChecker(), definitionId, "VIEW");
        return this.definitionLocalService.getDefinition(definitionId);
    }

    public List<Definition> getDefinitions(long groupId, String definitionName, String description, String sourceId, String reportName, boolean andSearch, int start, int end, OrderByComparator<Definition> orderByComparator) throws PortalException {
        return this.definitionFinder.filterFindByG_S_N_D_RN(groupId, definitionName, description, GetterUtil.getLong((String)sourceId), reportName, andSearch, start, end, orderByComparator);
    }

    public int getDefinitionsCount(long groupId, String definitionName, String description, String sourceId, String reportName, boolean andSearch) {
        return this.definitionFinder.filterCountByG_S_N_D_RN(groupId, definitionName, description, GetterUtil.getLong((String)sourceId), reportName, andSearch);
    }

    public Definition updateDefinition(long definitionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long sourceId, String reportParameters, String fileName, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        this._definitionModelResourcePermission.check(this.getPermissionChecker(), definitionId, "UPDATE");
        return this.definitionLocalService.updateDefinition(definitionId, nameMap, descriptionMap, sourceId, reportParameters, fileName, inputStream, serviceContext);
    }
}

