/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.impl;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.reports.engine.console.exception.DefinitionFileException;
import com.liferay.portal.reports.engine.console.exception.DefinitionNameException;
import com.liferay.portal.reports.engine.console.model.Definition;
import com.liferay.portal.reports.engine.console.service.base.DefinitionLocalServiceBaseImpl;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.reports.engine.console.model.Definition"}, service={AopService.class})
public class DefinitionLocalServiceImpl
extends DefinitionLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference(target="(default=true)")
    private Store _store;
    @Reference
    private UserLocalService _userLocalService;

    public Definition addDefinition(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long sourceId, String reportParameters, String fileName, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        this._validate(nameMap);
        long definitionId = this.counterLocalService.increment();
        Definition definition = this.definitionPersistence.create(definitionId);
        definition.setUuid(serviceContext.getUuid());
        definition.setGroupId(groupId);
        definition.setCompanyId(user.getCompanyId());
        definition.setUserId(user.getUserId());
        definition.setUserName(user.getFullName());
        definition.setCreateDate(serviceContext.getCreateDate(date));
        definition.setModifiedDate(serviceContext.getModifiedDate(date));
        definition.setNameMap(nameMap);
        definition.setDescriptionMap(descriptionMap);
        definition.setSourceId(sourceId);
        definition.setReportName(StringUtil.extractFirst((String)fileName, (String)"."));
        definition.setReportParameters(reportParameters);
        definition = (Definition)this.definitionPersistence.update((BaseModel)definition);
        this._resourceLocalService.addModelResources((AuditedModel)definition, serviceContext);
        if (!Validator.isNotNull((String)fileName) || inputStream == null) {
            throw new DefinitionFileException.InvalidDefinitionFile(fileName, inputStream == null);
        }
        this._addDefinitionFile(user.getCompanyId(), definition, fileName, inputStream);
        return definition;
    }

    @Override
    @SystemEvent(type=1)
    public Definition deleteDefinition(Definition definition) throws PortalException {
        this.definitionPersistence.remove((BaseModel)definition);
        this._resourceLocalService.deleteResource(definition.getCompanyId(), Definition.class.getName(), 4, definition.getDefinitionId());
        this.deleteDefinitionTemplates(definition.getCompanyId(), definition.getAttachmentsDir());
        return definition;
    }

    @Override
    public Definition deleteDefinition(long definitionId) throws PortalException {
        Definition definition = this.definitionPersistence.findByPrimaryKey(definitionId);
        return this.definitionLocalService.deleteDefinition(definition);
    }

    public void deleteDefinitions(long groupId) throws PortalException {
        List definitions = this.definitionPersistence.findByGroupId(groupId);
        for (Definition definition : definitions) {
            this.definitionLocalService.deleteDefinition(definition);
        }
    }

    public void deleteDefinitionTemplates(long companyId, String attachmentsDirectory) throws PortalException {
        this._store.deleteDirectory(companyId, 0L, attachmentsDirectory);
    }

    public String[] getAttachmentsFileNames(Definition definition) {
        return this._store.getFileNames(definition.getCompanyId(), 0L, definition.getAttachmentsDir());
    }

    public List<Definition> getDefinitions(long groupId, String definitionName, String description, String sourceId, String reportName, boolean andSearch, int start, int end, OrderByComparator<Definition> orderByComparator) {
        return this.definitionFinder.findByG_S_N_D_RN(groupId, definitionName, description, GetterUtil.getLong((String)sourceId), reportName, andSearch, start, end, orderByComparator);
    }

    public int getDefinitionsCount(long groupId, String definitionName, String description, String sourceId, String reportName, boolean andSearch) {
        return this.definitionFinder.countByG_S_N_D_RN(groupId, definitionName, description, GetterUtil.getLong((String)sourceId), reportName, andSearch);
    }

    public Definition updateDefinition(long definitionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, long sourceId, String reportParameters, String fileName, InputStream inputStream, ServiceContext serviceContext) throws PortalException {
        Definition definition = this.definitionPersistence.findByPrimaryKey(definitionId);
        this._validate(nameMap);
        definition.setModifiedDate(serviceContext.getModifiedDate(null));
        definition.setNameMap(nameMap);
        definition.setDescriptionMap(descriptionMap);
        definition.setSourceId(sourceId);
        if (Validator.isNotNull((String)fileName)) {
            definition.setReportName(StringUtil.extractFirst((String)fileName, (String)"."));
        }
        definition.setReportParameters(reportParameters);
        definition = (Definition)this.definitionPersistence.update((BaseModel)definition);
        ModelPermissions modelPermissions = serviceContext.getModelPermissions();
        if (modelPermissions == null) {
            this.updateDefinitionResources(definition, StringPool.EMPTY_ARRAY, StringPool.EMPTY_ARRAY);
        } else {
            this.updateDefinitionResources(definition, modelPermissions.getActionIds("PLACEHOLDER_DEFAULT_GROUP_ROLE"), modelPermissions.getActionIds("Guest"));
        }
        if (Validator.isNotNull((String)fileName) && inputStream != null) {
            long companyId = definition.getCompanyId();
            this._store.deleteDirectory(companyId, 0L, definition.getAttachmentsDir());
            this._addDefinitionFile(companyId, definition, fileName, inputStream);
        }
        return definition;
    }

    public void updateDefinitionResources(Definition definition, String[] communityPermissions, String[] guestPermissions) throws PortalException {
        this._resourceLocalService.updateResources(definition.getCompanyId(), definition.getGroupId(), Definition.class.getName(), definition.getDefinitionId(), communityPermissions, guestPermissions);
    }

    private void _addDefinitionFile(long companyId, Definition definition, String fileName, InputStream inputStream) throws PortalException {
        String directoryName = definition.getAttachmentsDir();
        String fileLocation = StringBundler.concat((String[])new String[]{directoryName, "/", fileName});
        this._store.addFile(companyId, 0L, fileLocation, "1.0", inputStream);
    }

    private void _validate(Map<Locale, String> nameMap) throws PortalException {
        Locale locale = LocaleUtil.getDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new DefinitionNameException.NullDefinitionFileName();
        }
    }
}

