/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.reports.engine.console.model.Source;
import com.liferay.portal.reports.engine.console.service.SourceServiceUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SourceServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(SourceServiceHttp.class);
    private static final Class<?>[] _addSourceParameterTypes0 = new Class[]{Long.TYPE, Map.class, String.class, String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteSourceParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSourceParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getSourcesParameterTypes3 = new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getSourcesCountParameterTypes4 = new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE};
    private static final Class<?>[] _updateSourceParameterTypes5 = new Class[]{Long.TYPE, Map.class, String.class, String.class, String.class, String.class, ServiceContext.class};

    public static Source addSource(HttpPrincipal httpPrincipal, long groupId, Map<Locale, String> nameMap, String driverClassName, String driverUrl, String driverUserName, String driverPassword, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SourceServiceUtil.class, "addSource", (Class[])_addSourceParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nameMap, driverClassName, driverUrl, driverUserName, driverPassword, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Source)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Source deleteSource(HttpPrincipal httpPrincipal, long sourceId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SourceServiceUtil.class, "deleteSource", (Class[])_deleteSourceParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Source)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Source getSource(HttpPrincipal httpPrincipal, long sourceId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SourceServiceUtil.class, "getSource", (Class[])_getSourceParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Source)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Source> getSources(HttpPrincipal httpPrincipal, long groupId, String name, String driverUrl, boolean andSearch, int start, int end, OrderByComparator<Source> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SourceServiceUtil.class, "getSources", (Class[])_getSourcesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, driverUrl, andSearch, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getSourcesCount(HttpPrincipal httpPrincipal, long groupId, String name, String driverUrl, boolean andSearch) {
        try {
            MethodKey methodKey = new MethodKey(SourceServiceUtil.class, "getSourcesCount", (Class[])_getSourcesCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, driverUrl, andSearch});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Source updateSource(HttpPrincipal httpPrincipal, long sourceId, Map<Locale, String> nameMap, String driverClassName, String driverUrl, String driverUserName, String driverPassword, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(SourceServiceUtil.class, "updateSource", (Class[])_updateSourceParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceId, nameMap, driverClassName, driverUrl, driverUserName, driverPassword, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Source)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

