/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.reports.engine.console.model.Entry;
import com.liferay.portal.reports.engine.console.service.EntryServiceUtil;
import java.util.Date;
import java.util.List;

public class EntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(EntryServiceHttp.class);
    private static final Class<?>[] _addEntryParameterTypes0 = new Class[]{Long.TYPE, Long.TYPE, String.class, Boolean.TYPE, Date.class, Date.class, Boolean.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteAttachmentParameterTypes1 = new Class[]{Long.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _deleteEntryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes3 = new Class[]{Long.TYPE, String.class, String.class, Date.class, Date.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getEntriesCountParameterTypes4 = new Class[]{Long.TYPE, String.class, String.class, Date.class, Date.class, Boolean.TYPE};
    private static final Class<?>[] _sendEmailsParameterTypes5 = new Class[]{Long.TYPE, String.class, String[].class, Boolean.TYPE};
    private static final Class<?>[] _unscheduleEntryParameterTypes6 = new Class[]{Long.TYPE};

    public static Entry addEntry(HttpPrincipal httpPrincipal, long groupId, long definitionId, String format, boolean schedulerRequest, Date startDate, Date endDate, boolean repeating, String recurrence, String emailNotifications, String emailDelivery, String portletId, String pageURL, String reportName, String reportParameters, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EntryServiceUtil.class, "addEntry", (Class[])_addEntryParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, definitionId, format, schedulerRequest, startDate, endDate, repeating, recurrence, emailNotifications, emailDelivery, portletId, pageURL, reportName, reportParameters, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Entry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteAttachment(HttpPrincipal httpPrincipal, long companyId, long entryId, String fileName) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EntryServiceUtil.class, "deleteAttachment", (Class[])_deleteAttachmentParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, entryId, fileName});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static Entry deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EntryServiceUtil.class, "deleteEntry", (Class[])_deleteEntryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Entry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<Entry> getEntries(HttpPrincipal httpPrincipal, long groupId, String definitionName, String userName, Date createDateGT, Date createDateLT, boolean andSearch, int start, int end, OrderByComparator<Entry> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, definitionName, userName, createDateGT, createDateLT, andSearch, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getEntriesCount(HttpPrincipal httpPrincipal, long groupId, String definitionName, String userName, Date createDateGT, Date createDateLT, boolean andSearch) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EntryServiceUtil.class, "getEntriesCount", (Class[])_getEntriesCountParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, definitionName, userName, createDateGT, createDateLT, andSearch});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void sendEmails(HttpPrincipal httpPrincipal, long entryId, String fileName, String[] emailAddresses, boolean notification) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EntryServiceUtil.class, "sendEmails", (Class[])_sendEmailsParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, fileName, emailAddresses, notification});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void unscheduleEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(EntryServiceUtil.class, "unscheduleEntry", (Class[])_unscheduleEntryParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

