/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.reports.engine.console.model.Source;
import com.liferay.portal.reports.engine.console.service.SourceLocalService;
import com.liferay.portal.reports.engine.console.service.SourceService;
import com.liferay.portal.reports.engine.console.service.persistence.SourceFinder;
import com.liferay.portal.reports.engine.console.service.persistence.SourcePersistence;
import java.sql.Connection;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class SourceServiceBaseImpl
extends BaseServiceImpl
implements AopService,
IdentifiableOSGiService,
SourceService {
    @Reference
    protected SourceLocalService sourceLocalService;
    protected SourceService sourceService;
    @Reference
    protected SourcePersistence sourcePersistence;
    @Reference
    protected SourceFinder sourceFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(SourceServiceBaseImpl.class);

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{SourceService.class, IdentifiableOSGiService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.sourceService = (SourceService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return SourceService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Source.class;
    }

    protected String getModelClassName() {
        return Source.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.sourcePersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

