/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.reports.engine.console.model.Entry;
import com.liferay.portal.reports.engine.console.service.EntryLocalService;
import com.liferay.portal.reports.engine.console.service.EntryService;
import com.liferay.portal.reports.engine.console.service.persistence.EntryFinder;
import com.liferay.portal.reports.engine.console.service.persistence.EntryPersistence;
import java.sql.Connection;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class EntryServiceBaseImpl
extends BaseServiceImpl
implements AopService,
EntryService,
IdentifiableOSGiService {
    @Reference
    protected EntryLocalService entryLocalService;
    protected EntryService entryService;
    @Reference
    protected EntryPersistence entryPersistence;
    @Reference
    protected EntryFinder entryFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(EntryServiceBaseImpl.class);

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{EntryService.class, IdentifiableOSGiService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.entryService = (EntryService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return EntryService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Entry.class;
    }

    protected String getModelClassName() {
        return Entry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.entryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

