/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.reports.engine.console.model.Definition;
import com.liferay.portal.reports.engine.console.service.DefinitionLocalService;
import com.liferay.portal.reports.engine.console.service.persistence.DefinitionFinder;
import com.liferay.portal.reports.engine.console.service.persistence.DefinitionPersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class DefinitionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
DefinitionLocalService,
IdentifiableOSGiService {
    protected DefinitionLocalService definitionLocalService;
    @Reference
    protected DefinitionPersistence definitionPersistence;
    @Reference
    protected DefinitionFinder definitionFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DefinitionLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Definition addDefinition(Definition definition) {
        definition.setNew(true);
        return (Definition)this.definitionPersistence.update((BaseModel)definition);
    }

    @Transactional(enabled=false)
    public Definition createDefinition(long definitionId) {
        return this.definitionPersistence.create(definitionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Definition deleteDefinition(long definitionId) throws PortalException {
        return this.definitionPersistence.remove(definitionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Definition deleteDefinition(Definition definition) throws PortalException {
        return (Definition)this.definitionPersistence.remove((BaseModel)definition);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.definitionPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Definition.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.definitionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.definitionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.definitionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.definitionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.definitionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Definition fetchDefinition(long definitionId) {
        return this.definitionPersistence.fetchByPrimaryKey(definitionId);
    }

    public Definition fetchDefinitionByUuidAndGroupId(String uuid, long groupId) {
        return this.definitionPersistence.fetchByUUID_G(uuid, groupId);
    }

    public Definition getDefinition(long definitionId) throws PortalException {
        return this.definitionPersistence.findByPrimaryKey(definitionId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.definitionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Definition.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("definitionId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.definitionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Definition.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("definitionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.definitionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Definition.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("definitionId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Definition>(){

            public void performAction(Definition definition) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)definition);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)Definition.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.definitionPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement DefinitionLocalServiceImpl#deleteDefinition(Definition) to avoid orphaned data");
        }
        return this.definitionLocalService.deleteDefinition((Definition)persistedModel);
    }

    public BasePersistence<Definition> getBasePersistence() {
        return this.definitionPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.definitionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<Definition> getDefinitionsByUuidAndCompanyId(String uuid, long companyId) {
        return this.definitionPersistence.findByUuid_C(uuid, companyId);
    }

    public List<Definition> getDefinitionsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<Definition> orderByComparator) {
        return this.definitionPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public Definition getDefinitionByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.definitionPersistence.findByUUID_G(uuid, groupId);
    }

    public List<Definition> getDefinitions(int start, int end) {
        return this.definitionPersistence.findAll(start, end);
    }

    public int getDefinitionsCount() {
        return this.definitionPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Definition updateDefinition(Definition definition) {
        return (Definition)this.definitionPersistence.update((BaseModel)definition);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{DefinitionLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.definitionLocalService = (DefinitionLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return DefinitionLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Definition.class;
    }

    protected String getModelClassName() {
        return Definition.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.definitionPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

