/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReportDefinitionUpgradeProcess
extends UpgradeProcess {
    private static final Pattern _pattern = Pattern.compile("[.*=.*=.*]+");

    protected void doUpgrade() throws Exception {
        if (this.hasTable("Reports_Definition")) {
            this._updateReportDefinitions();
        }
    }

    private void _updateReportDefinitions() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select companyId, definitionId, reportParameters from Reports_Definition");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Reports_Definition set reportParameters = ? where companyId = ? and definitionId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String reportParameters = resultSet.getString("reportParameters");
                String updatedReportParameters = this._updateReportParameters(reportParameters);
                if (Validator.isNotNull((String)reportParameters) && reportParameters.equals(updatedReportParameters)) continue;
                preparedStatement2.setString(1, reportParameters);
                preparedStatement2.setLong(2, resultSet.getLong("companyId"));
                preparedStatement2.setLong(3, resultSet.getLong("definitionId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private String _updateReportParameters(String reportParameters) {
        String[] keyValuePairs;
        Matcher matcher = _pattern.matcher(reportParameters);
        if (!matcher.find()) {
            return reportParameters;
        }
        JSONArray reportParametersJSONArray = JSONFactoryUtil.createJSONArray();
        for (String keyValuePair : keyValuePairs = StringUtil.split((String)reportParameters)) {
            if (Validator.isNull((String)keyValuePair) || !keyValuePair.contains("=")) continue;
            reportParametersJSONArray.put(JSONUtil.put((String)"key", (Object)keyValuePair.split("=")[0]).put("type", keyValuePair.split("=")[2]).put("value", keyValuePair.split("=")[1]));
        }
        return reportParametersJSONArray.toString();
    }
}

