/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.internal.messaging;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.reports.engine.console.configuration.ReportsPortletMessagingConfiguration;
import com.liferay.portal.reports.engine.console.service.EntryLocalService;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.reports.engine.console.configuration.ReportsPortletMessagingConfiguration"}, property={"destination.name=liferay/reports_scheduler_event"}, service={MessageListener.class})
public class SchedulerEventMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(SchedulerEventMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private EntryLocalService _entryLocalService;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        ReportsPortletMessagingConfiguration reportsPortletMessagingConfiguration = (ReportsPortletMessagingConfiguration)ConfigurableUtil.createConfigurable(ReportsPortletMessagingConfiguration.class, properties);
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/reports_scheduler_event");
        destinationConfiguration.setMaximumQueueSize(reportsPortletMessagingConfiguration.reportMessageQueueSize());
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the report console's task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        long entryId = message.getLong("entryId");
        String reportName = message.getString("reportName");
        this._entryLocalService.generateReport(entryId, reportName);
    }
}

