/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.reports.engine.console.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.reports.engine.ByteArrayReportResultContainer;
import com.liferay.portal.reports.engine.ReportDesignRetriever;
import com.liferay.portal.reports.engine.ReportEngine;
import com.liferay.portal.reports.engine.ReportGenerationException;
import com.liferay.portal.reports.engine.ReportRequest;
import com.liferay.portal.reports.engine.ReportResultContainer;
import com.liferay.portal.reports.engine.console.service.EntryLocalService;
import com.liferay.portal.reports.engine.console.status.ReportStatus;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/report_request"}, service={MessageListener.class})
public class ReportRequestMessageListener
extends BaseMessageListener {
    private static final int _MAXIMUM_QUEUE_SIZE = 200;
    private static final Log _log = LogFactoryUtil.getLog(ReportRequestMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private EntryLocalService _entryLocalService;
    @Reference
    private ReportEngine _reportEngine;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/report_request");
        destinationConfiguration.setMaximumQueueSize(200);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the graph walker's task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message) throws Exception {
        long entryId = GetterUtil.getLong((String)message.getResponseId());
        ReportRequest reportRequest = (ReportRequest)message.getPayload();
        ReportDesignRetriever reportDesignRetriever = reportRequest.getReportDesignRetriever();
        ByteArrayReportResultContainer reportResultContainer = new ByteArrayReportResultContainer(reportDesignRetriever.getReportName());
        try {
            this._reportEngine.execute(reportRequest, (ReportResultContainer)reportResultContainer);
        }
        catch (ReportGenerationException reportGenerationException) {
            _log.error((Object)"Unable to generate report", (Throwable)reportGenerationException);
            reportResultContainer.setReportGenerationException(reportGenerationException);
        }
        finally {
            if (reportResultContainer.hasError()) {
                reportGenerationException = reportResultContainer.getReportGenerationException();
                this._entryLocalService.updateEntryStatus(entryId, ReportStatus.ERROR, reportGenerationException.getMessage());
            } else {
                this._entryLocalService.updateEntry(entryId, reportResultContainer.getReportName(), reportResultContainer.getResults());
            }
        }
    }
}

