/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.properties.swapper.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.properties.swapper.internal.PropsHelperUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={})
public class DefaultCompanyNameSwapper {
    private static final Log _log = LogFactoryUtil.getLog(DefaultCompanyNameSwapper.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;

    @Activate
    protected void activate() {
        block5: {
            if (PropsHelperUtil.isCustomized("company.default.name")) {
                return;
            }
            String originalCompanyDefaultName = PropsValues.COMPANY_DEFAULT_NAME;
            PropsValues.COMPANY_DEFAULT_NAME = "Liferay DXP";
            try {
                Company defaultCompany = this._companyLocalService.getCompany(PortalInstancePool.getDefaultCompanyId());
                if (!this._hasCustomCompanyName(defaultCompany, originalCompanyDefaultName)) {
                    defaultCompany = this._updateCompanyName(defaultCompany);
                }
                if (!Objects.equals(defaultCompany.getWebId(), PropsValues.COMPANY_DEFAULT_WEB_ID) && !this._hasCustomCompanyName(defaultCompany = this._companyLocalService.getCompanyByWebId(PropsValues.COMPANY_DEFAULT_WEB_ID), originalCompanyDefaultName)) {
                    this._updateCompanyName(defaultCompany);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to swap default company name", (Throwable)portalException);
            }
        }
    }

    private boolean _hasCustomCompanyName(Company company, String defaultName) throws PortalException {
        String name = company.getName();
        return Validator.isNotNull((String)name) && !name.equals(defaultName);
    }

    private Company _updateCompanyName(Company company) {
        company.setName(PropsValues.COMPANY_DEFAULT_NAME);
        return this._companyLocalService.updateCompany(company);
    }
}

