/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.properties.swapper.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class PropsHelperUtil {
    private static final Log _log = LogFactoryUtil.getLog(PropsHelperUtil.class);
    private static final Map<String, Properties> _propertiesMap = new LinkedHashMap<String, Properties>();

    public static boolean isCustomized(String key) {
        for (Map.Entry<String, Properties> entry : _propertiesMap.entrySet()) {
            Properties properties = entry.getValue();
            if (!properties.containsKey(key)) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"Found customized value for key ", key, " in ", entry.getKey()}));
            }
            return true;
        }
        return false;
    }

    static {
        String[] propertiesLocations = PropsUtil.getArray((String)"include-and-override");
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        for (int i = propertiesLocations.length - 1; i >= 0; --i) {
            String propertiesLocation = propertiesLocations[i];
            try {
                Properties properties2;
                Throwable throwable;
                InputStream inputStream;
                if (Files.exists(Paths.get(propertiesLocation, new String[0]), new LinkOption[0])) {
                    inputStream = new FileInputStream(propertiesLocation);
                    throwable = null;
                    try {
                        properties2 = new Properties();
                        properties2.load(inputStream);
                        _propertiesMap.put(propertiesLocation, properties2);
                        continue;
                    }
                    catch (Throwable properties2) {
                        throwable = properties2;
                        throw properties2;
                    }
                    finally {
                        if (inputStream != null) {
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable properties2) {
                                    throwable.addSuppressed(properties2);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                inputStream = classLoader.getResourceAsStream(propertiesLocation);
                throwable = null;
                try {
                    if (inputStream == null) continue;
                    properties2 = new Properties();
                    properties2.load(inputStream);
                    _propertiesMap.put(propertiesLocation, properties2);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException ioException) {
                _log.error((Object)("Unable to read " + propertiesLocation), (Throwable)ioException);
                continue;
            }
            catch (InvalidPathException invalidPathException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Unable to parse " + propertiesLocation), (Throwable)invalidPathException);
            }
        }
    }
}

