/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.properties.swapper.internal;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={})
public class DefaultGuestGroupLogoSwapper {
    private CompanyLocalService _companyLocalService;
    private GroupLocalService _groupLocalService;
    private LayoutSetLocalService _layoutSetLocalService;

    @Reference(unbind="-")
    public void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    public void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        List companies = this._companyLocalService.getCompanies(0, 1);
        Company company = (Company)companies.get(0);
        Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(group.getGroupId(), false);
        if (layoutSet.getLogoId() != 0L) {
            return;
        }
        Bundle bundle = bundleContext.getBundle();
        URL url = bundle.getResource("com/liferay/portal/properties/swapper/internal/default_guest_group_logo.png");
        try (InputStream inputStream = url.openStream();){
            this._layoutSetLocalService.updateLogo(group.getGroupId(), false, true, inputStream);
        }
    }
}

