/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.osgi.debug.spring.extender.internal;

import com.liferay.portal.osgi.debug.SystemChecker;

import org.osgi.service.component.annotations.Component;

/**
 * @author Tina Tian
 */
@Component(immediate = true, service = SystemChecker.class)
public class SpringExtenderUnavailableComponentSystemChecker
	implements SystemChecker {

	@Override
	public String check() {
		return UnavailableComponentUtil.scanUnavailableComponents();
	}

	@Override
	public String getName() {
		return "Spring Extender Unavailable Component Checker";
	}

	@Override
	public String getOSGiCommand() {
		return "dm na";
	}

	@Override
	public String toString() {
		return getName();
	}

}