/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.osgi.debug.spring.extender.internal;

import com.liferay.portal.kernel.util.StringBundler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.DependencyManager;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * @author Tina Tian
 */
public class UnavailableComponentUtil {

	public static String scanUnavailableComponents() {
		StringBundler sb = new StringBundler();

		for (DependencyManager dependencyManager :
				(List<DependencyManager>)
					DependencyManager.getDependencyManagers()) {

			BundleContext bundleContext = dependencyManager.getBundleContext();

			Bundle bundle = bundleContext.getBundle();

			Map<ComponentDeclaration, List<ComponentDependencyDeclaration>>
				unavailableComponentDeclarations = new HashMap<>();

			for (ComponentDeclaration componentDeclaration :
					(List<ComponentDeclaration>)
						dependencyManager.getComponents()) {

				if (componentDeclaration.getState() !=
						ComponentDeclaration.STATE_UNREGISTERED) {

					continue;
				}

				List<ComponentDependencyDeclaration>
					componentDependencyDeclarations =
						unavailableComponentDeclarations.computeIfAbsent(
							componentDeclaration, key -> new ArrayList<>());

				for (ComponentDependencyDeclaration
						componentDependencyDeclaration :
							componentDeclaration.getComponentDependencies()) {

					if (componentDependencyDeclaration.getState() ==
							ComponentDependencyDeclaration.
								STATE_UNAVAILABLE_REQUIRED) {

						componentDependencyDeclarations.add(
							componentDependencyDeclaration);
					}
				}
			}

			if (!unavailableComponentDeclarations.isEmpty()) {
				sb.append("\nBundle {id: ");
				sb.append(bundle.getBundleId());
				sb.append(", name: ");
				sb.append(bundle.getSymbolicName());
				sb.append(", version: ");
				sb.append(bundle.getVersion());
				sb.append("}.\n");

				for (Map.Entry
						<ComponentDeclaration,
							List<ComponentDependencyDeclaration>> entry :
								unavailableComponentDeclarations.entrySet()) {

					sb.append("\tComponent with ID ");

					ComponentDeclaration componentDeclaration = entry.getKey();

					sb.append(componentDeclaration.getId());

					sb.append(" is unavailable due to missing required ");
					sb.append("dependencies:\n\t\t");

					for (ComponentDependencyDeclaration
							componentDependencyDeclaration :
								entry.getValue()) {

						sb.append(componentDependencyDeclaration);
						sb.append("\n\t\t");
					}

					sb.setIndex(sb.index() - 1);
				}
			}
		}

		return sb.toString();
	}

}