/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.debug.spring.extender.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.osgi.debug.spring.extender.internal.configuration.UnavailableComponentScannerConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.portal.osgi.debug.spring.extender.internal.configuration.UnavailableComponentScannerConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
public class UnavailableComponentScanner {
    private static final Log _log = LogFactoryUtil.getLog(UnavailableComponentScanner.class);
    private Thread _unavailableComponentScanningThread;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        UnavailableComponentScannerConfiguration unavailableComponentScannerConfiguration = (UnavailableComponentScannerConfiguration)ConfigurableUtil.createConfigurable(UnavailableComponentScannerConfiguration.class, properties);
        long scanningInterval = unavailableComponentScannerConfiguration.unavailableComponentScanningInterval();
        if (scanningInterval > 0L) {
            this._unavailableComponentScanningThread = new UnavailableComponentScanningThread(scanningInterval * 1000L);
            this._unavailableComponentScanningThread.start();
        }
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws InterruptedException {
        if (this._unavailableComponentScanningThread != null) {
            this._unavailableComponentScanningThread.interrupt();
            this._unavailableComponentScanningThread.join();
        }
    }

    private static void _scanUnavailableComponents() {
        StringBundler sb = new StringBundler();
        for (DependencyManager dependencyManager : DependencyManager.getDependencyManagers()) {
            BundleContext bundleContext = dependencyManager.getBundleContext();
            Bundle bundle = bundleContext.getBundle();
            HashMap<ComponentDeclaration, List> unavailableComponentDeclarations = new HashMap<ComponentDeclaration, List>();
            for (ComponentDeclaration componentDeclaration : dependencyManager.getComponents()) {
                if (componentDeclaration.getState() != 0) continue;
                List componentDependencyDeclarations = unavailableComponentDeclarations.computeIfAbsent(componentDeclaration, key -> new ArrayList());
                for (ComponentDependencyDeclaration componentDependencyDeclaration : componentDeclaration.getComponentDependencies()) {
                    if (componentDependencyDeclaration.getState() != 2) continue;
                    componentDependencyDeclarations.add(componentDependencyDeclaration);
                }
            }
            if (unavailableComponentDeclarations.isEmpty()) continue;
            sb.append("Found unavailable component in bundle {id: ");
            sb.append(bundle.getBundleId());
            sb.append(", name: ");
            sb.append(bundle.getSymbolicName());
            sb.append(", version: ");
            sb.append((Object)bundle.getVersion());
            sb.append("}.\n");
            for (Map.Entry entry : unavailableComponentDeclarations.entrySet()) {
                sb.append("\tComponent with ID ");
                ComponentDeclaration componentDeclaration = (ComponentDeclaration)entry.getKey();
                sb.append(componentDeclaration.getId());
                sb.append(" is unavailable due to missing required ");
                sb.append("dependencies:\n\t\t");
                for (ComponentDependencyDeclaration componentDependencyDeclaration : (List)entry.getValue()) {
                    sb.append((Object)componentDependencyDeclaration);
                    sb.append("\n\t\t");
                }
                sb.setStringAt("\n", sb.index() - 1);
            }
        }
        if (sb.index() == 0) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"All Spring extender dependency manager components are registered");
            }
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)sb.toString());
        }
    }

    private static class UnavailableComponentScanningThread
    extends Thread {
        private final long _scanningInterval;

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(this._scanningInterval);
                    UnavailableComponentScanner._scanUnavailableComponents();
                }
            }
            catch (InterruptedException ie) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Stopped scanning for unavailable components");
                }
                return;
            }
        }

        private UnavailableComponentScanningThread(long scanningInterval) {
            this._scanningInterval = scanningInterval;
            this.setDaemon(true);
            this.setName("Spring Extender Unavailable Component Scanner");
        }
    }
}

