/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.CacheResourceBundleLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;

public class LanguageExtension {
    private static final Log _log = LogFactoryUtil.getLog(LanguageExtension.class);
    private final Bundle _bundle;
    private final List<BundleCapability> _bundleCapabilities;
    private final BundleContext _bundleContext;
    private final List<Runnable> _closingRunnables = new ArrayList<Runnable>();
    private final Collection<ServiceRegistration<ResourceBundleLoader>> _serviceRegistrations = new ArrayList<ServiceRegistration<ResourceBundleLoader>>();

    public LanguageExtension(BundleContext bundleContext, Bundle bundle, List<BundleCapability> bundleCapabilities) {
        this._bundleContext = bundleContext;
        this._bundle = bundle;
        this._bundleCapabilities = bundleCapabilities;
    }

    public void destroy() {
        for (Runnable runnable : this._closingRunnables) {
            runnable.run();
        }
        for (ServiceRegistration serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    public void start() {
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        for (BundleCapability bundleCapability : this._bundleCapabilities) {
            ResourceBundleLoader resourceBundleLoader = null;
            HashMapDictionary attributes = new HashMapDictionary(bundleCapability.getAttributes());
            Object aggregate = attributes.get("resource.bundle.aggregate");
            String bundleSymbolicName = null;
            Object bundleSymbolicNameObject = attributes.get("bundle.symbolic.name");
            bundleSymbolicName = Validator.isNull(bundleSymbolicNameObject) ? this._bundle.getSymbolicName() : bundleSymbolicNameObject.toString();
            Object baseName = attributes.get("resource.bundle.base.name");
            if (aggregate instanceof String) {
                int serviceRanking = GetterUtil.getInteger(attributes.get("service.ranking"), (int)Integer.MIN_VALUE);
                resourceBundleLoader = this.processAggregate((String)aggregate, bundleSymbolicName, (String)baseName, serviceRanking);
            } else if (baseName instanceof String) {
                Object excludePortalResources = attributes.get("exclude.portal.resources");
                if (excludePortalResources == null) {
                    excludePortalResources = "false";
                }
                resourceBundleLoader = this.processBaseName(bundleWiring.getClassLoader(), (String)baseName, GetterUtil.getBoolean(excludePortalResources));
            }
            Object serviceRanking = attributes.get("service.ranking");
            if (Validator.isNotNull(serviceRanking)) {
                attributes.put("service.ranking", GetterUtil.getInteger(serviceRanking));
            }
            if (resourceBundleLoader != null) {
                this.registerResourceBundleLoader((Dictionary<String, Object>)attributes, resourceBundleLoader);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to handle ", bundleCapability, " in ", this._bundle.getSymbolicName()}));
        }
    }

    protected ResourceBundleLoader processAggregate(String aggregate, String bundleSymbolicName, String baseName, int limit) {
        String[] filterStrings = aggregate.split(",");
        ArrayList<ServiceTracker<ResourceBundleLoader, ResourceBundleLoader>> serviceTrackers = new ArrayList<ServiceTracker<ResourceBundleLoader, ResourceBundleLoader>>(filterStrings.length);
        for (String filterString : filterStrings) {
            Filter filter = null;
            filterString = StringBundler.concat((String[])new String[]{"(&(objectClass=", ResourceBundleLoader.class.getName(), ")", filterString, ")"});
            try {
                filter = this._bundleContext.createFilter(filterString);
            }
            catch (InvalidSyntaxException ise) {
                throw new IllegalArgumentException(ise);
            }
            PredicateServiceTracker serviceTracker = new PredicateServiceTracker(filter, new ResourceBundleLoaderPredicate(bundleSymbolicName, baseName, limit));
            serviceTracker.open();
            this._closingRunnables.add(() -> ((ServiceTracker)serviceTracker).close());
            serviceTrackers.add(serviceTracker);
        }
        return new ServiceTrackerResourceBundleLoader(serviceTrackers);
    }

    protected ResourceBundleLoader processBaseName(ClassLoader classLoader, String baseName, boolean excludePortalResource) {
        ResourceBundleLoader resourceBundleLoader = ResourceBundleUtil.getResourceBundleLoader((String)baseName, (ClassLoader)classLoader);
        if (excludePortalResource) {
            return new CacheResourceBundleLoader(resourceBundleLoader);
        }
        AggregateResourceBundleLoader aggregateResourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, ResourceBundleLoaderUtil.getPortalResourceBundleLoader()});
        return new CacheResourceBundleLoader((ResourceBundleLoader)aggregateResourceBundleLoader);
    }

    protected void registerResourceBundleLoader(Dictionary<String, Object> attributes, ResourceBundleLoader resourceBundleLoader) {
        if (Validator.isNull((Object)attributes.get("bundle.symbolic.name"))) {
            attributes.put("bundle.symbolic.name", this._bundle.getSymbolicName());
        }
        if (Validator.isNull((Object)attributes.get("service.ranking"))) {
            attributes.put("service.ranking", Integer.MIN_VALUE);
        }
        this._serviceRegistrations.add((ServiceRegistration<ResourceBundleLoader>)this._bundleContext.registerService(ResourceBundleLoader.class, (Object)resourceBundleLoader, attributes));
    }

    private class ResourceBundleLoaderPredicate
    implements Predicate<ServiceReference<ResourceBundleLoader>> {
        private final String _baseName;
        private final String _bundleSymbolicName;
        private final int _limit;

        public ResourceBundleLoaderPredicate(String bundleSymbolicName, String baseName, int limit) {
            this._bundleSymbolicName = bundleSymbolicName;
            this._baseName = baseName;
            this._limit = limit;
        }

        @Override
        public boolean test(ServiceReference<ResourceBundleLoader> serviceReference) {
            int serviceRanking;
            String bundleSymbolicName = null;
            Object bundleSymbolicNameObject = serviceReference.getProperty("bundle.symbolic.name");
            if (bundleSymbolicNameObject == null) {
                Bundle bundle = serviceReference.getBundle();
                bundleSymbolicName = bundle.getSymbolicName();
            } else {
                bundleSymbolicName = bundleSymbolicNameObject.toString();
            }
            String bundleBaseName = null;
            Object bundleBaseNameObject = serviceReference.getProperty("resource.bundle.base.name");
            bundleBaseName = bundleBaseNameObject == null ? "content.Language" : bundleBaseNameObject.toString();
            return !this._bundleSymbolicName.equals(bundleSymbolicName) || !this._baseName.equals(bundleBaseName) || this._limit > (serviceRanking = GetterUtil.getInteger((Object)serviceReference.getProperty("service.ranking"), (int)Integer.MIN_VALUE));
        }
    }

    private class PredicateServiceTracker
    extends ServiceTracker<ResourceBundleLoader, ResourceBundleLoader> {
        private final Predicate<ServiceReference<ResourceBundleLoader>> _predicate;

        public PredicateServiceTracker(Filter filter, Predicate<ServiceReference<ResourceBundleLoader>> predicate) {
            super(LanguageExtension.this._bundleContext, filter, null);
            this._predicate = predicate;
        }

        public ResourceBundleLoader addingService(ServiceReference<ResourceBundleLoader> serviceReference) {
            if (this._predicate.test(serviceReference)) {
                return (ResourceBundleLoader)LanguageExtension.this._bundleContext.getService(serviceReference);
            }
            return null;
        }

        public void modifiedService(ServiceReference<ResourceBundleLoader> serviceReference, ResourceBundleLoader resourceBundleLoader) {
            if (!this._predicate.test(serviceReference)) {
                LanguageExtension.this._bundleContext.ungetService(serviceReference);
                this.remove(serviceReference);
            }
            super.modifiedService(serviceReference, (Object)resourceBundleLoader);
        }
    }

    private static class ServiceTrackerResourceBundleLoader
    implements ResourceBundleLoader {
        private final List<ServiceTracker<ResourceBundleLoader, ResourceBundleLoader>> _serviceTrackers;

        public ServiceTrackerResourceBundleLoader(List<ServiceTracker<ResourceBundleLoader, ResourceBundleLoader>> serviceTrackers) {
            this._serviceTrackers = serviceTrackers;
        }

        public ResourceBundle loadResourceBundle(Locale locale) {
            ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
            for (ServiceTracker<ResourceBundleLoader, ResourceBundleLoader> serviceTracker : this._serviceTrackers) {
                ResourceBundle resourceBundle;
                ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)serviceTracker.getService();
                if (resourceBundleLoader == null || (resourceBundle = resourceBundleLoader.loadResourceBundle(locale)) == null) continue;
                resourceBundles.add(resourceBundle);
            }
            if (resourceBundles.isEmpty()) {
                return null;
            }
            if (resourceBundles.size() == 1) {
                return (ResourceBundle)resourceBundles.get(0);
            }
            return new AggregateResourceBundle(resourceBundles.toArray(new ResourceBundle[0]));
        }
    }
}

