/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fragment.bundle.watcher.internal;

import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;

@Component(service={})
public class PortalFragmentBundleWatcher {
    private BundleContext _bundleContext;
    private BundleTracker<String> _installedFragmentBundleTracker;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    private BundleListener _resolvedBundleListener;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._installedFragmentBundleTracker = new BundleTracker<String>(this._bundleContext, 2, null){

            public String addingBundle(Bundle bundle, BundleEvent event) {
                BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
                int types = bundleRevision.getTypes();
                if ((types & 1) == 0) {
                    return null;
                }
                return PortalFragmentBundleWatcher.this._getFragmentHost(bundle);
            }
        };
        this._installedFragmentBundleTracker.open();
        Bundle systemBundle = this._bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        this._resolvedBundleListener = bundleEvent -> {
            if (bundleEvent.getType() == 32) {
                Map installedFragmentBundles = this._installedFragmentBundleTracker.getTracked();
                if (installedFragmentBundles.isEmpty()) {
                    return;
                }
                HashSet fragmentHostSymbolicNames = new HashSet(installedFragmentBundles.values());
                Bundle originBundle = bundleEvent.getOrigin();
                long originBundleId = originBundle.getBundleId();
                ArrayList<Bundle> hostBundles = new ArrayList<Bundle>();
                for (Bundle bundle : bundleContext.getBundles()) {
                    if (!fragmentHostSymbolicNames.remove(bundle.getSymbolicName()) || originBundleId == bundle.getBundleId()) continue;
                    hostBundles.add(bundle);
                    if (fragmentHostSymbolicNames.isEmpty()) break;
                }
                if (!hostBundles.isEmpty()) {
                    frameworkWiring.refreshBundles(hostBundles, new FrameworkListener[0]);
                }
            }
        };
        this._bundleContext.addBundleListener(this._resolvedBundleListener);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleContext.removeBundleListener(this._resolvedBundleListener);
        this._installedFragmentBundleTracker.close();
    }

    private String _getFragmentHost(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders("");
        String fragmentHost = (String)dictionary.get("Fragment-Host");
        if (fragmentHost == null) {
            return null;
        }
        int index = fragmentHost.indexOf(59);
        if (index != -1) {
            fragmentHost = fragmentHost.substring(0, index);
        }
        return fragmentHost;
    }
}

