/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterExecutorImpl;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterTokenTransitionListener;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.NoticeableFutureConverter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={ClusterMasterExecutor.class})
public class ClusterMasterExecutorImpl
implements ClusterMasterExecutor {
    private static final Log _log = LogFactoryUtil.getLog(ClusterMasterExecutorImpl.class);
    private static volatile boolean _master;
    private ClusterEventListener _clusterEventListener;
    private ClusterExecutorImpl _clusterExecutorImpl;
    private final Set<ClusterMasterTokenTransitionListener> _clusterMasterTokenTransitionListeners = new HashSet<ClusterMasterTokenTransitionListener>();
    private boolean _enabled;
    private volatile String _localClusterNodeId;

    public void addClusterMasterTokenTransitionListener(ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener) {
        this._clusterMasterTokenTransitionListeners.add(clusterMasterTokenTransitionListener);
    }

    public <T> NoticeableFuture<T> executeOnMaster(MethodHandler methodHandler) {
        if (!this._enabled) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Executing on the local node because the cluster master executor is disabled");
            }
            DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
            try {
                defaultNoticeableFuture.set(methodHandler.invoke());
                return defaultNoticeableFuture;
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        }
        final String masterClusterNodeId = this.getMasterClusterNodeId(true);
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((Serializable)methodHandler, (String[])new String[]{masterClusterNodeId});
        try {
            return new NoticeableFutureConverter<T, ClusterNodeResponses>((NoticeableFuture)this._clusterExecutorImpl.execute(clusterRequest)){

                protected T convert(ClusterNodeResponses clusterNodeResponses) throws Exception {
                    ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(masterClusterNodeId);
                    return clusterNodeResponse.getResult();
                }
            };
        }
        catch (Exception exception) {
            throw new SystemException("Unable to execute on master " + masterClusterNodeId, (Throwable)exception);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isMaster() {
        if (this.isEnabled()) {
            return _master;
        }
        return true;
    }

    public void removeClusterMasterTokenTransitionListener(ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener) {
        this._clusterMasterTokenTransitionListeners.remove(clusterMasterTokenTransitionListener);
    }

    @Activate
    protected synchronized void activate() {
        if (!this._clusterExecutorImpl.isEnabled()) {
            return;
        }
        this._clusterEventListener = new ClusterMasterTokenClusterEventListener();
        this._clusterExecutorImpl.addClusterEventListener(this._clusterEventListener);
        ClusterNode localClusterNode = this._clusterExecutorImpl.getLocalClusterNode();
        this._localClusterNodeId = localClusterNode.getClusterNodeId();
        this._enabled = true;
        this.getMasterClusterNodeId(false);
    }

    @Deactivate
    protected void deactivate() {
        if (this._clusterEventListener != null) {
            this._clusterExecutorImpl.removeClusterEventListener(this._clusterEventListener);
        }
        this._clusterEventListener = null;
        this._enabled = false;
        this._localClusterNodeId = null;
    }

    protected String getMasterClusterNodeId(boolean notify) {
        ClusterChannel clusterChannel;
        ClusterReceiver clusterReceiver;
        Address coordinatorAddress;
        boolean master = false;
        String masterClusterNodeId = null;
        while (!Validator.isNotNull((String)(masterClusterNodeId = (master = (coordinatorAddress = (clusterReceiver = (clusterChannel = this._clusterExecutorImpl.getClusterChannel()).getClusterReceiver()).getCoordinatorAddress()).equals(clusterChannel.getLocalAddress())) ? this._localClusterNodeId : this._clusterExecutorImpl.getClusterNodeId(coordinatorAddress)))) {
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Unable to get cluster node information for ", "coordinator address ", coordinatorAddress, ". Trying again."}));
        }
        if (master == _master) {
            return masterClusterNodeId;
        }
        _master = master;
        if (notify) {
            this.notifyMasterTokenTransitionListeners(master);
        }
        return masterClusterNodeId;
    }

    protected void notifyMasterTokenTransitionListeners(boolean masterTokenAcquired) {
        for (ClusterMasterTokenTransitionListener clusterMasterTokenTransitionListener : this._clusterMasterTokenTransitionListeners) {
            if (masterTokenAcquired) {
                clusterMasterTokenTransitionListener.masterTokenAcquired();
                continue;
            }
            clusterMasterTokenTransitionListener.masterTokenReleased();
        }
    }

    @Reference(unbind="-")
    protected void setClusterExecutorImpl(ClusterExecutorImpl clusterExecutorImpl) {
        this._clusterExecutorImpl = clusterExecutorImpl;
    }

    protected void setClusterMasterTokenTransitionListeners(Set<ClusterMasterTokenTransitionListener> clusterMasterTokenTransitionListeners) {
        this._clusterMasterTokenTransitionListeners.addAll(clusterMasterTokenTransitionListeners);
    }

    private class ClusterMasterTokenClusterEventListener
    implements ClusterEventListener {
        private ClusterMasterTokenClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            ClusterEventType clusterEventType = clusterEvent.getClusterEventType();
            if (clusterEventType == ClusterEventType.COORDINATOR_ADDRESS_UPDATE) {
                ClusterMasterExecutorImpl.this.getMasterClusterNodeId(true);
            }
        }
    }
}

