/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.jgroups;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterChannelFactory;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.io.ClusterClassLoaderPool;
import com.liferay.portal.cluster.multiple.internal.jgroups.JGroupsClusterChannel;
import com.liferay.portal.cluster.multiple.internal.jgroups.JGroupsLogAdapter;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SocketUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.jgroups.logging.CustomLogFactory;
import org.jgroups.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;

@Component(configurationPid={"com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration"}, immediate=true, service={ClusterChannelFactory.class})
public class JGroupsClusterChannelFactory
implements ClusterChannelFactory {
    private static final Log _log = LogFactoryUtil.getLog(JGroupsClusterChannelFactory.class);
    private InetAddress _bindInetAddress;
    private NetworkInterface _bindNetworkInterface;
    private BundleTracker<ClassLoader> _bundleTracker;
    private final ConcurrentMap<ClassLoader, ClassLoader> _classLoaders = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private volatile ClusterExecutorConfiguration _clusterExecutorConfiguration;
    private Props _props;

    @Override
    public ClusterChannel createClusterChannel(ExecutorService executorService, String channleLogicName, String channelProperties, String clusterName, ClusterReceiver clusterReceiver) {
        return new JGroupsClusterChannel(executorService, channleLogicName, channelProperties, clusterName, clusterReceiver, this._bindInetAddress, this._clusterExecutorConfiguration, this._classLoaders);
    }

    @Override
    public InetAddress getBindInetAddress() {
        return this._bindInetAddress;
    }

    @Override
    public NetworkInterface getBindNetworkInterface() {
        return this._bindNetworkInterface;
    }

    @Activate
    @Modified
    protected synchronized void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._clusterExecutorConfiguration = (ClusterExecutorConfiguration)ConfigurableUtil.createConfigurable(ClusterExecutorConfiguration.class, properties);
        if (!GetterUtil.getBoolean((String)this._props.get("cluster.link.enabled"))) {
            return;
        }
        this.initSystemProperties(this._props.getArray("cluster.link.channel.system.properties"));
        this.initBindAddress(GetterUtil.getString((String)this._props.get("cluster.link.autodetect.address")));
        LogFactory.setCustomLogFactory((CustomLogFactory)new CustomLogFactory(){

            public org.jgroups.logging.Log getLog(Class clazz) {
                return new JGroupsLogAdapter(clazz);
            }

            public org.jgroups.logging.Log getLog(String category) {
                return new JGroupsLogAdapter(category);
            }
        });
        this._bundleTracker = new BundleTracker<ClassLoader>(bundleContext, 32, null){

            public ClassLoader addingBundle(Bundle bundle, BundleEvent event) {
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                ClassLoader classLoader = bundleWiring.getClassLoader();
                ClusterClassLoaderPool.registerFallback(bundle.getSymbolicName(), bundle.getVersion(), classLoader);
                return classLoader;
            }

            public void removedBundle(Bundle bundle, BundleEvent event, ClassLoader classLoader) {
                ClusterClassLoaderPool.unregisterFallback(bundle.getSymbolicName(), bundle.getVersion());
            }
        };
        this._bundleTracker.open();
    }

    @Deactivate
    protected synchronized void deactive() {
        if (this._bundleTracker != null) {
            this._bundleTracker.close();
        }
        this._classLoaders.clear();
    }

    protected void initBindAddress(String autodetectAddress) {
        if (Validator.isNull((String)autodetectAddress)) {
            return;
        }
        String host = autodetectAddress;
        int port = 80;
        int index = autodetectAddress.indexOf(58);
        if (index != -1) {
            host = autodetectAddress.substring(0, index);
            port = GetterUtil.getInteger((String)autodetectAddress.substring(index + 1), (int)port);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Autodetecting JGroups outgoing IP address and interface ", "for ", host, ":", port}));
        }
        try {
            SocketUtil.BindInfo bindInfo = SocketUtil.getBindInfo((String)host, (int)port);
            this._bindInetAddress = bindInfo.getInetAddress();
            this._bindNetworkInterface = bindInfo.getNetworkInterface();
        }
        catch (IOException e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to detect bind address for JGroups, using loopback");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
            }
            this._bindInetAddress = InetAddress.getLoopbackAddress();
            try {
                this._bindNetworkInterface = NetworkInterface.getByInetAddress(this._bindInetAddress);
            }
            catch (IOException ie) {
                _log.error((Object)"Unable to bind to lopoback interface", (Throwable)ie);
            }
        }
        if (_log.isInfoEnabled()) {
            String hostAddress = this._bindInetAddress.getHostAddress();
            String name = this._bindNetworkInterface.getName();
            _log.info((Object)StringBundler.concat((String[])new String[]{"Setting JGroups outgoing IP address to ", hostAddress, " and interface to ", name}));
        }
    }

    protected void initSystemProperties(String[] channelSystemPropertiesArray) {
        for (String channelSystemProperty : channelSystemPropertiesArray) {
            int index = channelSystemProperty.indexOf(58);
            if (index == -1) continue;
            String key = channelSystemProperty.substring(0, index);
            String value = channelSystemProperty.substring(index + 1);
            System.setProperty(key, value);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Setting system property {key=", key, ", value=", value, "}"}));
        }
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }
}

