/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.io;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.osgi.framework.Version;

public class ClusterClassLoaderPool {
    private static final Log _log = LogFactoryUtil.getLog(ClusterClassLoaderPool.class);
    private static final Map<String, ConcurrentNavigableMap<Version, ClassLoader>> _fallbackClassLoaders = new ConcurrentHashMap<String, ConcurrentNavigableMap<Version, ClassLoader>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoader(String contextName) {
        ClassLoader classLoader = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (contextName != null && !contextName.equals("null")) {
            Map.Entry entry;
            String symbolicName;
            ConcurrentNavigableMap<Version, ClassLoader> classLoaders;
            int pos;
            try {
                currentThread.setContextClassLoader(null);
                classLoader = ClassLoaderPool.getClassLoader((String)contextName);
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
            if (classLoader == null && (pos = contextName.indexOf(95)) > 0 && (classLoaders = _fallbackClassLoaders.get(symbolicName = contextName.substring(0, pos))) != null && (entry = classLoaders.lastEntry()) != null) {
                classLoader = (ClassLoader)entry.getValue();
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to find class loader for ", contextName, ", class loader ", symbolicName, "_", entry.getKey(), " is provided instead"}));
                }
            }
            if (classLoader == null && _log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to find class loader for ", contextName, ", fall back to current thread's context class ", "loader"}));
            }
        }
        if (classLoader == null) {
            classLoader = contextClassLoader;
        }
        return classLoader;
    }

    public static String getContextName(ClassLoader classLoader) {
        String contextName = ClassLoaderPool.getContextName((ClassLoader)classLoader);
        if (classLoader != null && contextName.equals("null") && _log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to find context name for ", classLoader.toString(), ", send 'null' as context name instead"}));
        }
        return contextName;
    }

    public static void registerFallback(String symbolicName, Version version, ClassLoader classLoader) {
        _fallbackClassLoaders.compute(symbolicName, (key, classLoaders) -> {
            if (classLoaders == null) {
                classLoaders = new ConcurrentSkipListMap<Version, ClassLoader>();
            }
            classLoaders.put(version, classLoader);
            return classLoaders;
        });
    }

    public static void unregisterFallback(String symbolicName, Version version) {
        _fallbackClassLoaders.computeIfPresent(symbolicName, (key, classLoaders) -> {
            classLoaders.remove(version);
            if (classLoaders.isEmpty()) {
                return null;
            }
            return classLoaders;
        });
    }
}

