/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.jgroups;

import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.io.ClusterSerializationUtil;
import com.liferay.portal.cluster.multiple.internal.jgroups.AddressImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

public class JGroupsReceiver
extends ReceiverAdapter {
    private static final Log _log = LogFactoryUtil.getLog(JGroupsReceiver.class);
    private final ClusterReceiver _clusterReceiver;

    public JGroupsReceiver(ClusterReceiver clusterReceiver) {
        if (clusterReceiver == null) {
            throw new NullPointerException("Cluster receiver is null");
        }
        this._clusterReceiver = clusterReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        byte[] rawBuffer = message.getRawBuffer();
        if (rawBuffer == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Message content is null");
            }
            return;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader aggregatedClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)contextClassLoader, (ClassLoader[])new ClassLoader[]{JGroupsReceiver.class.getClassLoader()});
        currentThread.setContextClassLoader(aggregatedClassLoader);
        try {
            this._clusterReceiver.receive(ClusterSerializationUtil.readObject(rawBuffer, message.getOffset(), message.getLength()), new AddressImpl(message.getSrc()));
        }
        catch (ClassNotFoundException cnfe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to deserialize message payload", (Throwable)cnfe);
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void viewAccepted(View view) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Accepted view " + view));
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        AddressImpl coordinatorAddress = null;
        List jGroupsAddresses = view.getMembers();
        for (int i = 0; i < jGroupsAddresses.size(); ++i) {
            AddressImpl address = new AddressImpl((org.jgroups.Address)jGroupsAddresses.get(i));
            if (i == 0) {
                coordinatorAddress = address;
            }
            addresses.add(address);
        }
        this._clusterReceiver.addressesUpdated(addresses);
        this._clusterReceiver.coordinatorAddressUpdated(coordinatorAddress);
    }
}

