/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.jgroups;

import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.io.ClusterSerializationUtil;
import com.liferay.portal.cluster.multiple.internal.jgroups.AddressImpl;
import com.liferay.portal.cluster.multiple.internal.jgroups.JGroupsReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.InetAddress;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public class JGroupsClusterChannel
implements ClusterChannel {
    private static final Log _log = LogFactoryUtil.getLog(JGroupsClusterChannel.class);
    private final String _clusterName;
    private final ClusterReceiver _clusterReceiver;
    private final JChannel _jChannel;
    private final Address _localAddress;

    public JGroupsClusterChannel(String channelLogicName, String channelProperties, String clusterName, ClusterReceiver clusterReceiver, InetAddress bindInetAddress) {
        if (Validator.isNull((String)channelProperties)) {
            throw new NullPointerException("Channel properties is null");
        }
        if (Validator.isNull((String)clusterName)) {
            throw new NullPointerException("Cluster name is null");
        }
        if (clusterReceiver == null) {
            throw new NullPointerException("Cluster receiver is null");
        }
        this._clusterName = clusterName;
        this._clusterReceiver = clusterReceiver;
        try {
            this._jChannel = new JChannel(channelProperties);
            if (Validator.isNotNull((String)channelLogicName)) {
                this._jChannel.setName(channelLogicName);
            }
            if (bindInetAddress != null) {
                ProtocolStack protocolStack = this._jChannel.getProtocolStack();
                TP tp = protocolStack.getTransport();
                tp.setBindAddress(bindInetAddress);
            }
            this._jChannel.setReceiver((Receiver)new JGroupsReceiver(clusterReceiver));
            this._jChannel.connect(this._clusterName);
            this._localAddress = new AddressImpl(this._jChannel.getAddress());
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Create a new JGroups channel with properties " + this._jChannel.getProperties()));
            }
        }
        catch (Exception e) {
            throw new SystemException("Unable to initial cluster channel " + clusterName, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this._jChannel.setReceiver(null);
        this._jChannel.close();
    }

    @Override
    public InetAddress getBindInetAddress() {
        ProtocolStack protocolStack = this._jChannel.getProtocolStack();
        Protocol protocol = protocolStack.getBottomProtocol();
        if (!(protocol instanceof TP)) {
            throw new IllegalStateException("Bottom protocol of jgroups is not a transport protocol");
        }
        TP transportProtocol = (TP)protocol;
        return (InetAddress)transportProtocol.getValue("bind_addr");
    }

    @Override
    public String getClusterName() {
        return this._clusterName;
    }

    @Override
    public ClusterReceiver getClusterReceiver() {
        return this._clusterReceiver;
    }

    @Override
    public Address getLocalAddress() {
        return this._localAddress;
    }

    @Override
    public void sendMulticastMessage(Serializable message) {
        this.sendMessage(message, null);
    }

    @Override
    public void sendUnicastMessage(Serializable message, Address address) {
        if (address == null) {
            throw new SystemException("Target address is null");
        }
        this.sendMessage(message, (org.jgroups.Address)address.getRealAddress());
    }

    protected void sendMessage(Serializable message, org.jgroups.Address address) {
        if (this._jChannel.isClosed()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Cluster channel " + this._clusterName + " is alreay closed"));
            }
            return;
        }
        if (message == null) {
            throw new IllegalArgumentException("Message sent to address " + address + " cannot be null");
        }
        try {
            this._jChannel.send(address, ClusterSerializationUtil.writeObject(message));
            if (_log.isDebugEnabled()) {
                if (address == null) {
                    _log.debug((Object)("Send multicast message " + message));
                } else {
                    _log.debug((Object)("Send unicast message " + message));
                }
            }
        }
        catch (Exception e) {
            if (address == null) {
                throw new SystemException("Unable to send multicast message", (Throwable)e);
            }
            throw new SystemException("Unable to send unicast message", (Throwable)e);
        }
    }
}

