/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.io;

import com.liferay.petra.io.ProtectedObjectInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.petra.lang.ClassResolverUtil;
import com.liferay.portal.cluster.multiple.internal.io.ClusterClassLoaderPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;

public class ClusterSerializationUtil {
    public static Object readObject(byte[] bytes, int offset, int length) throws ClassNotFoundException {
        byte serializableType = bytes[offset];
        if (9 != serializableType) {
            throw new IllegalStateException("Unable to deserialize this type:" + serializableType);
        }
        try {
            ClusterProtectedAnnotatedObjectInputStream objectInputStream = new ClusterProtectedAnnotatedObjectInputStream((InputStream)new UnsyncByteArrayInputStream(bytes, offset + 1, length - 1));
            return ((ObjectInputStream)((Object)objectInputStream)).readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static byte[] writeObject(Serializable serializable) {
        try {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            unsyncByteArrayOutputStream.write(9);
            ClusterAnnotatedObjectOutputStream objectOutputStream = new ClusterAnnotatedObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            return unsyncByteArrayOutputStream.unsafeGetByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write ordinary serializable object " + serializable, ioe);
        }
    }

    private static class ClusterProtectedAnnotatedObjectInputStream
    extends ProtectedObjectInputStream {
        protected Class<?> doResolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
            String contextName = this.readUTF();
            ClassLoader classLoader = ClusterClassLoaderPool.getClassLoader(contextName);
            String className = objectStreamClass.getName();
            return ClassResolverUtil.resolve((String)className, (ClassLoader)classLoader);
        }

        private ClusterProtectedAnnotatedObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }
    }

    private static class ClusterAnnotatedObjectOutputStream
    extends ObjectOutputStream {
        @Override
        protected void annotateClass(Class<?> clazz) throws IOException {
            ClassLoader classLoader = clazz.getClassLoader();
            String contextName = ClusterClassLoaderPool.getContextName(classLoader);
            this.writeUTF(contextName);
        }

        private ClusterAnnotatedObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
        }
    }
}

