/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.cluster.multiple.internal;

import com.liferay.portal.kernel.cluster.Address;

import java.util.List;

/**
 * @author Tina Tian
 */
public interface ClusterReceiver {

	public void addressesUpdated(List<Address> addresses);

	public void coordinatorAddressUpdated(Address coordinatorAddress);

	public List<Address> getAddresses();

	public Address getCoordinatorAddress();

	public void openLatch();

	public void receive(Object messagePayload, Address srcAddress);

}