/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.cluster.multiple.internal;

import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterTokenTransitionListener;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/**
 * @author Shuyang Zhou
 */
@Component(immediate = true)
public class ClusterMasterTokenTransitionListenerTracker {

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTracker = new ServiceTracker<>(
			bundleContext, ClusterMasterTokenTransitionListener.class,
			new ServiceTrackerCustomizer
				<ClusterMasterTokenTransitionListener,
					ClusterMasterTokenTransitionListener>() {

				@Override
				public ClusterMasterTokenTransitionListener addingService(
					ServiceReference<ClusterMasterTokenTransitionListener>
						serviceReference) {

					ClusterMasterTokenTransitionListener
						clusterMasterTokenTransitionListener =
							bundleContext.getService(serviceReference);

					_clusterMasterExecutor.
						addClusterMasterTokenTransitionListener(
							clusterMasterTokenTransitionListener);

					return clusterMasterTokenTransitionListener;
				}

				@Override
				public void modifiedService(
					ServiceReference<ClusterMasterTokenTransitionListener>
						serviceReference,
					ClusterMasterTokenTransitionListener
						clusterMasterTokenTransitionListener) {
				}

				@Override
				public void removedService(
					ServiceReference<ClusterMasterTokenTransitionListener>
						serviceReference,
					ClusterMasterTokenTransitionListener
						clusterMasterTokenTransitionListener) {

					_clusterMasterExecutor.
						removeClusterMasterTokenTransitionListener(
							clusterMasterTokenTransitionListener);

					bundleContext.ungetService(serviceReference);
				}

			});
	}

	@Deactivate
	protected void deactivate() {
		_serviceTracker.close();
	}

	@Reference
	private ClusterMasterExecutor _clusterMasterExecutor;

	private ServiceTracker
		<ClusterMasterTokenTransitionListener,
			ClusterMasterTokenTransitionListener> _serviceTracker;

}