/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.cluster.multiple.internal;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;

import java.util.List;

/**
 * @author Shuyang Zhou
 */
public class ClusterForwardReceiver extends BaseClusterReceiver {

	public ClusterForwardReceiver(ClusterLinkImpl clusterLinkImpl) {
		super(clusterLinkImpl.getExecutorService());

		_clusterLinkImpl = clusterLinkImpl;
	}

	@Override
	protected void doReceive(Object messagePayload, Address srcAddress) {
		List<Address> localAddresses = _clusterLinkImpl.getLocalAddresses();

		if (localAddresses.contains(srcAddress)) {
			if (_log.isDebugEnabled()) {
				_log.debug("Block received message " + messagePayload);
			}
		}
		else {
			_clusterLinkImpl.sendLocalMessage((Message)messagePayload);
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		ClusterForwardReceiver.class);

	private final ClusterLinkImpl _clusterLinkImpl;

}