/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.cluster.multiple.internal;

import com.liferay.portal.kernel.cluster.Address;

import java.io.Serializable;

import java.net.InetAddress;

/**
 * @author Tina Tian
 */
public interface ClusterChannel {

	public void close();

	public InetAddress getBindInetAddress();

	public String getClusterName();

	public ClusterReceiver getClusterReceiver();

	public Address getLocalAddress();

	public void sendMulticastMessage(Serializable message);

	public void sendUnicastMessage(Serializable message, Address address);

}