/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterChannelFactory;
import com.liferay.portal.cluster.multiple.internal.ClusterForwardReceiver;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ClusterLink.class})
public class ClusterLinkImpl
implements ClusterLink {
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkImpl.class);
    private int _channelCount;
    private ClusterChannelFactory _clusterChannelFactory;
    private List<ClusterChannel> _clusterChannels;
    private List<ClusterReceiver> _clusterReceivers;
    private boolean _enabled;
    private ExecutorService _executorService;
    private List<Address> _localAddresses;
    private MessageBus _messageBus;
    private PortalExecutorManager _portalExecutorManager;
    private Props _props;

    public boolean isEnabled() {
        return this._enabled;
    }

    public void sendMulticastMessage(Message message, Priority priority) {
        if (!this.isEnabled()) {
            return;
        }
        ClusterChannel clusterChannel = this.getChannel(priority);
        clusterChannel.sendMulticastMessage((Serializable)message);
    }

    public void sendUnicastMessage(Address address, Message message, Priority priority) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._localAddresses.contains(address)) {
            this.sendLocalMessage(message);
            return;
        }
        ClusterChannel clusterChannel = this.getChannel(priority);
        clusterChannel.sendUnicastMessage((Serializable)message, address);
    }

    @Activate
    protected void activate() {
        this._enabled = GetterUtil.getBoolean((String)this._props.get("cluster.link.enabled"));
        if (this._enabled) {
            this.initialize(this.getChannelSettings("cluster.link.channel.logic.name.transport"), this.getChannelSettings("cluster.link.channel.properties.transport"), this.getChannelSettings("cluster.link.channel.name.transport"));
        }
    }

    @Deactivate
    protected void deactivate() {
        if (!this._enabled) {
            return;
        }
        if (this._clusterChannels != null) {
            for (ClusterChannel clusterChannel : this._clusterChannels) {
                clusterChannel.close();
            }
        }
        this._localAddresses = null;
        this._clusterChannels = null;
        this._clusterReceivers = null;
        if (this._executorService != null) {
            this._executorService.shutdownNow();
        }
        this._executorService = null;
    }

    protected ClusterChannel getChannel(Priority priority) {
        int channelIndex = priority.ordinal() * this._channelCount / MAX_CHANNEL_COUNT;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Select channel number ", String.valueOf(channelIndex), " for priority ", String.valueOf(priority)}));
        }
        return this._clusterChannels.get(channelIndex);
    }

    protected Map<String, String> getChannelSettings(String propertyPrefix) {
        HashMap<String, String> channelSettings = new HashMap<String, String>();
        Properties channelProperties = this._props.getProperties(propertyPrefix, true);
        for (Map.Entry<Object, Object> entry : channelProperties.entrySet()) {
            channelSettings.put((String)entry.getKey(), (String)entry.getValue());
        }
        return channelSettings;
    }

    protected ExecutorService getExecutorService() {
        return this._executorService;
    }

    protected List<Address> getLocalAddresses() {
        return this._localAddresses;
    }

    protected void initChannels(Map<String, String> channelLogicNames, Map<String, String> channelPropertiesStrings, Map<String, String> channelNames) throws Exception {
        this._channelCount = channelPropertiesStrings.size();
        if (this._channelCount <= 0 || this._channelCount > MAX_CHANNEL_COUNT) {
            throw new IllegalArgumentException("Channel count must be between 1 and " + MAX_CHANNEL_COUNT);
        }
        this._localAddresses = new ArrayList<Address>(this._channelCount);
        this._clusterChannels = new ArrayList<ClusterChannel>(this._channelCount);
        this._clusterReceivers = new ArrayList<ClusterReceiver>(this._channelCount);
        ArrayList<String> keys = new ArrayList<String>(channelPropertiesStrings.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String channelPropertiesString = channelPropertiesStrings.get(key);
            String channelName = channelNames.get(key);
            String channelLogicName = channelLogicNames.get(key);
            if (Validator.isNull((String)channelPropertiesString) || Validator.isNull((String)channelName)) continue;
            ClusterForwardReceiver clusterReceiver = new ClusterForwardReceiver(this);
            ClusterChannel clusterChannel = this._clusterChannelFactory.createClusterChannel(this._executorService, channelLogicName, channelPropertiesString, channelName, clusterReceiver);
            this._clusterChannels.add(clusterChannel);
            this._clusterReceivers.add(clusterReceiver);
            this._localAddresses.add(clusterChannel.getLocalAddress());
        }
    }

    protected void initialize(Map<String, String> channelLogicNames, Map<String, String> channelPropertiesStrings, Map<String, String> channelNames) {
        this._executorService = this._portalExecutorManager.getPortalExecutor(ClusterLinkImpl.class.getName());
        try {
            this.initChannels(channelLogicNames, channelPropertiesStrings, channelNames);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to initialize channels", (Throwable)e);
            throw new IllegalStateException(e);
        }
        for (ClusterReceiver clusterReceiver : this._clusterReceivers) {
            clusterReceiver.openLatch();
        }
    }

    protected void sendLocalMessage(Message message) {
        String destinationName = message.getDestinationName();
        if (Validator.isNotNull((String)destinationName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Sending local cluster link message ", String.valueOf(message), " to ", destinationName}));
            }
            ClusterInvokeThreadLocal.setEnabled((boolean)false);
            try {
                this._messageBus.sendMessage(destinationName, message);
            }
            finally {
                ClusterInvokeThreadLocal.setEnabled((boolean)true);
            }
        } else {
            _log.error((Object)("Local cluster link message has no destination " + message));
        }
    }

    @Reference(unbind="-")
    protected void setClusterChannelFactory(ClusterChannelFactory clusterChannelFactory) {
        this._clusterChannelFactory = clusterChannelFactory;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    @Reference(unbind="-")
    protected void setPortalExecutorManager(PortalExecutorManager portalExecutorManager) {
        this._portalExecutorManager = portalExecutorManager;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    protected void unsetMessageBus(MessageBus messageBus) {
        this._messageBus = null;
    }
}

