/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cache.io.SerializableObjectWrapper;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEventType;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class PortalCacheClusterEvent
implements Serializable {
    private static final Log _log = LogFactoryUtil.getLog(PortalCacheClusterEvent.class);
    private final SerializableObjectWrapper _elementKey;
    private byte[] _elementValueBytes;
    private final PortalCacheClusterEventType _portalCacheClusterEventType;
    private final String _portalCacheManagerName;
    private final String _portalCacheName;
    private int _timeToLive;

    public PortalCacheClusterEvent(String portalCacheManagerName, String portalCacheName, Serializable elementKey, PortalCacheClusterEventType portalCacheClusterEventType) {
        this(portalCacheManagerName, portalCacheName, elementKey, null, 0, portalCacheClusterEventType);
    }

    public PortalCacheClusterEvent(String portalCacheManagerName, String portalCacheName, Serializable elementKey, Serializable elementValue, int timeToLive, PortalCacheClusterEventType portalCacheClusterEventType) {
        if (portalCacheManagerName == null) {
            throw new NullPointerException("Portal cache manager name is null");
        }
        if (portalCacheName == null) {
            throw new NullPointerException("Portal cache name is null");
        }
        if (portalCacheClusterEventType == null) {
            throw new NullPointerException("Portal cache cluster event type is null");
        }
        if (elementKey == null && !portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVE_ALL)) {
            throw new NullPointerException("Element key is null");
        }
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        this._portalCacheManagerName = portalCacheManagerName;
        this._portalCacheName = portalCacheName;
        this._elementKey = new SerializableObjectWrapper(elementKey);
        this._timeToLive = timeToLive;
        this._portalCacheClusterEventType = portalCacheClusterEventType;
        this.setElementValue(elementValue);
    }

    public Serializable getElementKey() {
        return (Serializable)SerializableObjectWrapper.unwrap((Object)this._elementKey);
    }

    public Serializable getElementValue() {
        if (this._elementValueBytes == null) {
            return null;
        }
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(this._elementValueBytes));
        try {
            return deserializer.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            _log.error((Object)"Unable to deserialize object", (Throwable)classNotFoundException);
            return null;
        }
    }

    public PortalCacheClusterEventType getEventType() {
        return this._portalCacheClusterEventType;
    }

    public String getPortalCacheManagerName() {
        return this._portalCacheManagerName;
    }

    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    public int getTimeToLive() {
        return this._timeToLive;
    }

    public void setElementValue(Serializable elementValue) {
        if (elementValue == null) {
            return;
        }
        Serializer serializer = new Serializer();
        serializer.writeObject(elementValue);
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        this._elementValueBytes = byteBuffer.array();
    }

    public void setTimeToLive(int timeToLive) {
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        this._timeToLive = timeToLive;
    }

    public String toString() {
        StringBundler sb = new StringBundler(13);
        sb.append("{elementKey=");
        sb.append((Object)this._elementKey);
        if (this._elementValueBytes != null) {
            sb.append(", elementValueBytes.length=");
            sb.append(this._elementValueBytes.length);
        }
        sb.append(", timeToLive=");
        sb.append(this._timeToLive);
        sb.append(", portalCacheClusterEventType=");
        sb.append((Object)this._portalCacheClusterEventType);
        sb.append(", portalCacheManagerName=");
        sb.append(this._portalCacheManagerName);
        sb.append(", portalCacheName=");
        sb.append(this._portalCacheName);
        sb.append("}");
        return sb.toString();
    }
}

