/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal;

import com.liferay.portal.cache.io.SerializableObjectWrapper;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEventType;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.util.Objects;

public class PortalCacheClusterEvent
implements Serializable {
    private final SerializableObjectWrapper _elementKey;
    private SerializableObjectWrapper _elementValue;
    private final PortalCacheClusterEventType _portalCacheClusterEventType;
    private final String _portalCacheManagerName;
    private final String _portalCacheName;
    private int _timeToLive;

    public PortalCacheClusterEvent(String portalCacheManagerName, String portalCacheName, Serializable elementKey, PortalCacheClusterEventType portalCacheClusterEventType) {
        this(portalCacheManagerName, portalCacheName, elementKey, null, 0, portalCacheClusterEventType);
    }

    public PortalCacheClusterEvent(String portalCacheManagerName, String portalCacheName, Serializable elementKey, Serializable elementValue, int timeToLive, PortalCacheClusterEventType portalCacheClusterEventType) {
        if (portalCacheManagerName == null) {
            throw new NullPointerException("Portal cache manager name is null");
        }
        if (portalCacheName == null) {
            throw new NullPointerException("Portal cache name is null");
        }
        if (portalCacheClusterEventType == null) {
            throw new NullPointerException("Portal cache cluster event type is null");
        }
        if (elementKey == null && !portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVE_ALL)) {
            throw new NullPointerException("Element key is null");
        }
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        this._portalCacheManagerName = portalCacheManagerName;
        this._portalCacheName = portalCacheName;
        this._elementKey = new SerializableObjectWrapper(elementKey);
        this._elementValue = new SerializableObjectWrapper(elementValue);
        this._timeToLive = timeToLive;
        this._portalCacheClusterEventType = portalCacheClusterEventType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PortalCacheClusterEvent)) {
            return false;
        }
        PortalCacheClusterEvent portalCacheClusterEvent = (PortalCacheClusterEvent)obj;
        return Objects.equals(this._elementKey, portalCacheClusterEvent._elementKey) && Objects.equals(this._elementValue, portalCacheClusterEvent._elementValue) && Objects.equals((Object)this._portalCacheClusterEventType, (Object)portalCacheClusterEvent._portalCacheClusterEventType) && Objects.equals(this._portalCacheManagerName, portalCacheClusterEvent._portalCacheManagerName) && Objects.equals(this._portalCacheName, portalCacheClusterEvent._portalCacheName);
    }

    public Serializable getElementKey() {
        return (Serializable)SerializableObjectWrapper.unwrap((Object)this._elementKey);
    }

    public Serializable getElementValue() {
        return (Serializable)SerializableObjectWrapper.unwrap((Object)this._elementValue);
    }

    public PortalCacheClusterEventType getEventType() {
        return this._portalCacheClusterEventType;
    }

    public String getPortalCacheManagerName() {
        return this._portalCacheManagerName;
    }

    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    public int getTimeToLive() {
        return this._timeToLive;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setElementValue(Serializable elementValue) {
        this._elementValue = new SerializableObjectWrapper(elementValue);
    }

    public void setTimeToLive(int timeToLive) {
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        this._timeToLive = timeToLive;
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append(this._portalCacheManagerName);
        sb.append(":");
        sb.append(this._portalCacheName);
        sb.append(":");
        sb.append((Object)this._elementKey);
        sb.append(":");
        if (this._elementValue != null) {
            sb.append(this._elementValue.toString());
            sb.append(":");
        }
        sb.append(this._portalCacheClusterEventType.toString());
        return sb.toString();
    }
}

