/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.multiple.internal.bootstrap;

import com.liferay.portal.cache.PortalCacheBootstrapLoader;
import com.liferay.portal.cache.ehcache.spi.EhcacheUnwrapUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerProvider;
import com.liferay.portal.kernel.cache.SkipReplicationThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;

public class EhcachePortalCacheBootstrapLoaderAdapter
implements PortalCacheBootstrapLoader {
    private static final Log _log = LogFactoryUtil.getLog(EhcachePortalCacheBootstrapLoaderAdapter.class);
    private final boolean _bootstrapAsynchronously;
    private final BootstrapCacheLoader _bootstrapCacheLoader;
    private final ClusterExecutor _clusterExecutor;
    private final ExecutorService _executorService;

    public EhcachePortalCacheBootstrapLoaderAdapter(BootstrapCacheLoader bootstrapCacheLoader, boolean bootstrapAsynchronously, ExecutorService executorService, ClusterExecutor clusterExecutor) {
        this._bootstrapCacheLoader = bootstrapCacheLoader;
        this._bootstrapAsynchronously = bootstrapAsynchronously;
        this._executorService = executorService;
        this._clusterExecutor = clusterExecutor;
    }

    public boolean isAsynchronous() {
        return this._bootstrapAsynchronously;
    }

    public void loadPortalCache(String portalCacheManagerName, String portalCacheName) {
        List clusterNodes = this._clusterExecutor.getClusterNodes();
        if (clusterNodes.size() == 1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Not loading cache ", portalCacheName, "from cluster ", "because a cluster peer was not found"}));
            }
            return;
        }
        PortalCacheManager portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager((String)portalCacheManagerName);
        if (!portalCacheManager.isClusterAware()) {
            _log.error((Object)("Unable to load cache within cache manager " + portalCacheManagerName));
            return;
        }
        final PortalCache portalCache = portalCacheManager.getPortalCache(portalCacheName);
        if (!this._bootstrapAsynchronously) {
            this._loadPortalCache(portalCache);
            return;
        }
        this._executorService.submit(new Runnable(){

            @Override
            public void run() {
                EhcachePortalCacheBootstrapLoaderAdapter.this._loadPortalCache(portalCache);
            }
        });
    }

    private void _loadPortalCache(PortalCache<?, ?> portalCache) {
        boolean enabled = SkipReplicationThreadLocal.isEnabled();
        SkipReplicationThreadLocal.setEnabled((boolean)true);
        try {
            this._bootstrapCacheLoader.load(EhcacheUnwrapUtil.getEhcache(portalCache));
        }
        finally {
            SkipReplicationThreadLocal.setEnabled((boolean)enabled);
        }
    }
}

