/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.cache.ehcache.multiple.internal.bootstrap;

import com.liferay.portal.cache.PortalCacheBootstrapLoader;
import com.liferay.portal.kernel.util.GetterUtil;

import java.util.Properties;

/**
 * @author Tina Tian
 */
public class RMIBootstrapCacheLoaderFactory
	extends net.sf.ehcache.distribution.RMIBootstrapCacheLoaderFactory {

	protected boolean extractBootstrapAsynchronously(Properties properties) {
		return GetterUtil.getBoolean(
			properties.getProperty(
				PortalCacheBootstrapLoader.BOOTSTRAP_ASYNCHRONOUSLY),
			PortalCacheBootstrapLoader.DEFAULT_BOOTSTRAP_ASYNCHRONOUSLY);
	}

}