/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.cache.ehcache.multiple.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Tina Tian
 */
@ExtendedObjectClassDefinition(category = "infrastructure")
@Meta.OCD(
	id = "com.liferay.portal.cache.ehcache.multiple.configuration.EhcacheMultipleConfiguration",
	localization = "content/Language",
	name = "ehcache-multiple-configuration-name"
)
public interface EhcacheMultipleConfiguration {

	@Meta.AD(
		deflt = "com.liferay.portal.cache.ehcache.multiple.internal.bootstrap.RMIBootstrapCacheLoaderFactory",
		required = false
	)
	public String bootstrapCacheLoaderFactoryClass();

	@Meta.AD(
		deflt = "com.liferay.portal.cache.ehcache.multiple.internal.distribution.RMICacheReplicatorFactory",
		required = false
	)
	public String cacheReplicatorFactoryClass();

}