/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.multiple.internal.distribution;

import com.liferay.portal.cache.PortalCacheReplicator;
import com.liferay.portal.cache.ehcache.event.EhcachePortalCacheListenerAdapter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.lang.reflect.Field;
import net.sf.ehcache.distribution.RMIAsynchronousCacheReplicator;
import net.sf.ehcache.event.CacheEventListener;

public class EhcachePortalCacheReplicatorAdapter<K extends Serializable, V extends Serializable>
extends EhcachePortalCacheListenerAdapter<K, V>
implements PortalCacheReplicator<K, V> {
    private static final Field _REPLICATION_THREAD_FIELD;
    private static final long _WAIT_TIME = 1000L;
    private static final Log _log;

    public EhcachePortalCacheReplicatorAdapter(CacheEventListener cacheEventListener) {
        super(cacheEventListener);
    }

    public void dispose() {
        block4: {
            super.dispose();
            if (!(this.cacheEventListener instanceof RMIAsynchronousCacheReplicator)) {
                return;
            }
            RMIAsynchronousCacheReplicator rmiAsynchronousCacheReplicator = (RMIAsynchronousCacheReplicator)this.cacheEventListener;
            try {
                Thread replicationThread = (Thread)_REPLICATION_THREAD_FIELD.get(rmiAsynchronousCacheReplicator);
                replicationThread.interrupt();
                replicationThread.join(1000L);
                if (replicationThread.isAlive() && _log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Give up waiting on thread ", String.valueOf(replicationThread), " after waiting for ", String.valueOf(1000L), "ms"}));
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to dispose cache event listener " + this.cacheEventListener), (Throwable)e);
            }
        }
    }

    static {
        _log = LogFactoryUtil.getLog(EhcachePortalCacheReplicatorAdapter.class);
        try {
            _REPLICATION_THREAD_FIELD = ReflectionUtil.getDeclaredField(RMIAsynchronousCacheReplicator.class, (String)"replicationThread");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

