/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.multiple.internal.bootstrap;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.cache.PortalCacheBootstrapLoader;
import com.liferay.portal.cache.PortalCacheBootstrapLoaderFactory;
import com.liferay.portal.cache.ehcache.multiple.configuration.EhcacheMultipleConfiguration;
import com.liferay.portal.cache.ehcache.multiple.internal.bootstrap.EhcachePortalCacheBootstrapLoaderAdapter;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import java.util.Dictionary;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.cache.ehcache.multiple.configuration.EhcacheMultipleConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={PortalCacheBootstrapLoaderFactory.class})
public class EhcachePortalCacheBootstrapLoaderFactory
implements PortalCacheBootstrapLoaderFactory {
    @Reference
    private ClusterExecutor _clusterExecutor;
    private volatile EhcacheMultipleConfiguration _ehcacheMultipleConfiguration;
    private ExecutorService _executorService;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    public PortalCacheBootstrapLoader create(Properties properties) {
        String factoryClassName = this._ehcacheMultipleConfiguration.bootstrapCacheLoaderFactoryClass();
        try {
            BootstrapCacheLoaderFactory bootstrapCacheLoaderFactory = (BootstrapCacheLoaderFactory)InstanceFactory.newInstance((ClassLoader)this.getClassLoader(), (String)factoryClassName);
            boolean bootstrapAsynchronously = GetterUtil.getBoolean((String)properties.getProperty("bootstrapAsynchronously"), (boolean)true);
            Properties newProperties = (Properties)properties.clone();
            newProperties.put("bootstrapAsynchronously", "false");
            return new EhcachePortalCacheBootstrapLoaderAdapter(bootstrapCacheLoaderFactory.createBootstrapCacheLoader(newProperties), bootstrapAsynchronously, this._executorService, this._clusterExecutor);
        }
        catch (Exception e) {
            throw new SystemException("Unable to instantiate bootstrap cache loader factory " + factoryClassName, (Throwable)e);
        }
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext) {
        this._ehcacheMultipleConfiguration = (EhcacheMultipleConfiguration)ConfigurableUtil.createConfigurable(EhcacheMultipleConfiguration.class, (Dictionary)componentContext.getProperties());
        this._executorService = this._portalExecutorManager.getPortalExecutor(EhcachePortalCacheBootstrapLoaderFactory.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        if (this._executorService != null) {
            this._executorService.shutdown();
        }
    }

    protected ClassLoader getClassLoader() {
        Class<?> clazz = this.getClass();
        return clazz.getClassLoader();
    }
}

