/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.background.task.model.BackgroundTask;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.background.task.service.persistence.BackgroundTaskFinder;
import com.liferay.portal.background.task.service.persistence.BackgroundTaskPersistence;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class BackgroundTaskLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
BackgroundTaskLocalService,
IdentifiableOSGiService {
    protected BackgroundTaskLocalService backgroundTaskLocalService;
    @Reference
    protected BackgroundTaskPersistence backgroundTaskPersistence;
    @Reference
    protected BackgroundTaskFinder backgroundTaskFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public BackgroundTask addBackgroundTask(BackgroundTask backgroundTask) {
        backgroundTask.setNew(true);
        return (BackgroundTask)this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
    }

    @Transactional(enabled=false)
    public BackgroundTask createBackgroundTask(long backgroundTaskId) {
        return this.backgroundTaskPersistence.create(backgroundTaskId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BackgroundTask deleteBackgroundTask(long backgroundTaskId) throws PortalException {
        return this.backgroundTaskPersistence.remove(backgroundTaskId);
    }

    @Indexable(type=IndexableType.DELETE)
    public BackgroundTask deleteBackgroundTask(BackgroundTask backgroundTask) throws PortalException {
        return (BackgroundTask)this.backgroundTaskPersistence.remove((BaseModel)backgroundTask);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.backgroundTaskPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(BackgroundTask.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.backgroundTaskPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.backgroundTaskPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.backgroundTaskPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.backgroundTaskPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.backgroundTaskPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public BackgroundTask fetchBackgroundTask(long backgroundTaskId) {
        return this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
    }

    public BackgroundTask getBackgroundTask(long backgroundTaskId) throws PortalException {
        return this.backgroundTaskPersistence.findByPrimaryKey(backgroundTaskId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.backgroundTaskLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BackgroundTask.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("backgroundTaskId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.backgroundTaskLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(BackgroundTask.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("backgroundTaskId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.backgroundTaskLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(BackgroundTask.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("backgroundTaskId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.backgroundTaskPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement BackgroundTaskLocalServiceImpl#deleteBackgroundTask(BackgroundTask) to avoid orphaned data");
        }
        return this.backgroundTaskLocalService.deleteBackgroundTask((BackgroundTask)persistedModel);
    }

    public BasePersistence<BackgroundTask> getBasePersistence() {
        return this.backgroundTaskPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.backgroundTaskPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<BackgroundTask> getBackgroundTasks(int start, int end) {
        return this.backgroundTaskPersistence.findAll(start, end);
    }

    public int getBackgroundTasksCount() {
        return this.backgroundTaskPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public BackgroundTask updateBackgroundTask(BackgroundTask backgroundTask) {
        return (BackgroundTask)this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{BackgroundTaskLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.backgroundTaskLocalService = (BackgroundTaskLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return BackgroundTaskLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return BackgroundTask.class;
    }

    protected String getModelClassName() {
        return BackgroundTask.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.backgroundTaskPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

