/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal.lock.helper;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistryUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;

public class BackgroundTaskLockHelper {
    private final LockManager _lockManager;

    public BackgroundTaskLockHelper(LockManager lockManager) {
        this._lockManager = lockManager;
    }

    public boolean isLockedBackgroundTask(BackgroundTask backgroundTask) {
        return this._lockManager.isLocked(BackgroundTaskExecutor.class.getName(), this._getLockKey(backgroundTask));
    }

    public Lock lockBackgroundTask(BackgroundTask backgroundTask) {
        String owner = backgroundTask.getName() + "#" + backgroundTask.getBackgroundTaskId();
        return this._lockManager.lock(BackgroundTaskExecutor.class.getName(), this._getLockKey(backgroundTask), owner);
    }

    public void unlockBackgroundTask(BackgroundTask backgroundTask) {
        String owner = backgroundTask.getName() + "#" + backgroundTask.getBackgroundTaskId();
        this._lockManager.unlock(BackgroundTaskExecutor.class.getName(), this._getLockKey(backgroundTask), owner);
    }

    private String _getLockKey(BackgroundTask backgroundTask) {
        BackgroundTaskExecutor backgroundTaskExecutor = BackgroundTaskExecutorRegistryUtil.getBackgroundTaskExecutor((String)backgroundTask.getTaskExecutorClassName());
        Object lockKey = "";
        lockKey = backgroundTaskExecutor.getIsolationLevel() == 1 ? backgroundTask.getTaskExecutorClassName() : (backgroundTaskExecutor.getIsolationLevel() == 2 ? backgroundTask.getTaskExecutorClassName() + "#" + backgroundTask.getCompanyId() : (backgroundTaskExecutor.getIsolationLevel() == 6 ? backgroundTaskExecutor.generateLockKey(backgroundTask) : (backgroundTaskExecutor.getIsolationLevel() == 3 ? backgroundTask.getTaskExecutorClassName() + "#" + backgroundTask.getGroupId() : (backgroundTaskExecutor.getIsolationLevel() == 5 ? backgroundTask.getTaskExecutorClassName() + "#" + backgroundTask.getName() : backgroundTask.getTaskExecutorClassName() + "#" + backgroundTaskExecutor.getIsolationLevel()))));
        return lockKey;
    }
}

