/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusMessageTranslator;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistryUtil;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BackgroundTaskStatusRegistry.class})
public class BackgroundTaskStatusRegistryImpl
implements BackgroundTaskStatusRegistry {
    private static final Log _log = LogFactoryUtil.getLog(BackgroundTaskStatusRegistryImpl.class);
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    private final Map<Long, Map.Entry<BackgroundTaskStatus, BackgroundTaskStatusMessageTranslator>> _entries = new ConcurrentHashMap<Long, Map.Entry<BackgroundTaskStatus, BackgroundTaskStatusMessageTranslator>>();

    public BackgroundTaskStatus getBackgroundTaskStatus(long backgroundTaskId) {
        if (!this._clusterMasterExecutor.isMaster()) {
            return this._getMasterBackgroundTaskStatus(backgroundTaskId);
        }
        Map.Entry<BackgroundTaskStatus, BackgroundTaskStatusMessageTranslator> entry = this._entries.get(backgroundTaskId);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    public BackgroundTaskStatusMessageTranslator getBackgroundTaskStatusMessageTranslator(long backgroundTaskId) {
        Map.Entry<BackgroundTaskStatus, BackgroundTaskStatusMessageTranslator> entry = this._entries.get(backgroundTaskId);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public BackgroundTaskStatus registerBackgroundTaskStatus(long backgroundTaskId, BackgroundTaskStatusMessageTranslator backgroundTaskStatusMessageTranslator) {
        Map.Entry entry = this._entries.computeIfAbsent(backgroundTaskId, key -> new AbstractMap.SimpleImmutableEntry<BackgroundTaskStatus, BackgroundTaskStatusMessageTranslator>(new BackgroundTaskStatus(), backgroundTaskStatusMessageTranslator));
        return (BackgroundTaskStatus)entry.getKey();
    }

    public BackgroundTaskStatus unregisterBackgroundTaskStatus(long backgroundTaskId) {
        Map.Entry<BackgroundTaskStatus, BackgroundTaskStatusMessageTranslator> entry = this._entries.remove(backgroundTaskId);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    private BackgroundTaskStatus _getMasterBackgroundTaskStatus(long backgroundTaskId) {
        try {
            MethodHandler methodHandler = new MethodHandler(BackgroundTaskStatusRegistryUtil.class.getDeclaredMethod("getBackgroundTaskStatus", Long.TYPE), new Object[]{backgroundTaskId});
            NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(methodHandler);
            return (BackgroundTaskStatus)future.get();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get master background task status", (Throwable)exception);
            return null;
        }
    }
}

